function configStruct = getGFtboxConfig()
% Read the GFtbox configuration file and return the config as a struct.

    configStruct.GFtboxName = 'GFtbox';

    whereami = fileparts(mfilename('fullpath'));
    configStruct.codedirectory = fileparts(whereami);
    [configStruct.revnum,configStruct.revdate] = svnrevision( configStruct.codedirectory, false );

    configStruct.configFilename = fullfile( configStruct.codedirectory, ...
        [ configStruct.GFtboxName '_config.txt' ] );
    % Set default config info.
    configFromFile = structFromFile( configStruct.configFilename );
    if isfield( configFromFile, 'revnum' )
        [v,n] = sscanf( configFromFile.revnum, '%d', 1 );
        if n ~= 1, v = 0; end
        configFromFile.revnum = v;
    end
    if isfield( configFromFile, 'FontSize' )
        [v,n] = sscanf( configFromFile.FontSize, '%d', 1 );
        if n ~= 1, v = 0; end
        configFromFile.FontSize = v;
    end
    if isfield( configFromFile, 'dir' )
        configFromFile.userdir = configFromFile.dir;
        configFromFile = rmfield( configFromFile, 'dir' );
    end
    configStruct = defaultFromStruct( configStruct, configFromFile );
    configStruct = defaultFromStruct( configStruct, ...
        struct(  ...
            'compressor', 'None', ...
               'userdir', '', ...
                'revnum', 0, ...
               'revdate', '', ...
      'bioedgethickness', 1, ...
         'biovertexsize', 1, ...
              'FontName', '', ...
             'FontUnits', '', ...
              'FontSize', 0, ...
            'FontWeight', '', ...
             'FontAngle', '' ) );
end
