function [m,ok] = leaf_setthickness( m, varargin )
%[m,ok] = leaf_setthickness( m, thickness )
%   Set the thickness of the leaf everywhere to the specified value.
%   This only affects the current mesh and does not modify any of the
%   static mesh properties.
%
%   If thickness is being handled non-physically, the effect of this
%   command will be overridden on the next simulation step.  In that case
%   you should call leaf_setthicknessparams instead.
%
%   see also: leaf_setthicknessparams.
%
%   Topics: Mesh editing.

    if isempty(m), return; end
    [ok, thickness, args] = getTypedArg( mfilename(), 'numeric', varargin );
    if ~ok,
        return;
    end
    if thickness <= 0
        fprintf( 1, '%s: thickness must be positive, value %f given.\n', ...
            mfilename(), thickness );
        ok = false;
        return;
    end
    if ~isempty(args)
        fprintf( 1, '%s: %d extra arguments ignored.\n', mfilename(), length(args) );
    end
    
    m = setAbsoluteThickness( m, thickness );
end
