function m = leaf_refineFEM( m, varargin )
%m = leaf_refineFEM( m, amount )
%   AMOUNT is between 0 and 1.  Split that proportion of the edges of the
%   finite element mesh, in random order.
%   Example:
%       m = leaf_refineFEM( m, 0.3 );
%
%   Equivalent GUI operation: clicking the "Refine mesh" button in the
%   "Mesh editor" panel.  The scroll bar and text box set the proportion of
%   edges to be split.
%
%   Topics: Mesh editing.


    if isempty(m), return; end
    [ok, amount, args] = getTypedArg( mfilename(), 'double', varargin );
    if ~ok, return; end
    if ~isempty(args)
        fprintf( 1, '%s: %d extra arguments ignored.\n', mfilename(), length(args) );
    end

    m = refinemesh( m, amount );
end
