function m = leaf_mgen_edge( m, varargin )
%m = leaf_mgen_edge( m, morphogen, amount, ... )
%   Set the value of a specified morphogen to a given amount everywhere on
%   the edge of the leaf.
%   Arguments:
%   1: The name or index of a morphogen.
%   2: The maximum amount of morphogen to add to every node.
%   Examples:
%       m = leaf_mgen_edge( m, 'growth', 1 );
%   See also: leaf_mgen_const.
%
%   Equivalent GUI operation: clicking the "Add edge" button in the
%   "Morphogens" panel.  The amount is specified by the "Amount slider and
%   test item.
%
%   Topics: Morphogens.

    if isempty(m), return; end
    [ok1, morphogen, args] = getTypedArg( mfilename(), {'numeric','char'}, varargin );
    if ok1
        [ok2, amount, args] = getTypedArg( mfilename(), 'double', args );
    end
    if ~(ok1 && ok2), return; end
    if ~isempty(args)
        fprintf( 1, '%s: %d extra arguments ignored.\n', mfilename(), length(args) );
    end

    g = FindMorphogenIndex( m, morphogen, mfilename() );
    for i=1:length(g)
        m = setedgegrowth( m, amount, g(i), 1 );
    end
end
