function mgenIndex = FindMorphogenIndex( mesh, mgen, message )
    if isempty( mesh )
        mgenIndex = [];
        return;
    end
    if nargin < 3
        message = '';
    end
    if isnumeric( mgen )
        mgen = abs(mgen);
        okindexmap = (1 <= mgen) & (mgen <= size(mesh.morphogens,2));
        badindexes = mgen(~okindexmap);
        if ~isempty(message) && ~isempty(badindexes)
            if length(badindexes)==1
                fprintf( 1, '%s: No such morphogen index as %d.\n', message, badindexes );
            else
                fprintf( 1, '%s: No such morphogen indexes as', message );
                fprintf( 1, ' %d', badindexes );
                fprintf( 1, '.\n' );
            end
        end
        mgenIndex = mgen(okindexmap);
    elseif ischar(mgen)
        mgen = upper(mgen);
        if isfield( mesh.mgenNameToIndex, mgen )
            mgenIndex = mesh.mgenNameToIndex.(mgen);
        else
            if ~isempty(message)
                fprintf( 1, '%s: No such morphogen as "%s".\n', message, mgen );
            end
            mgenIndex = [];
        end
    elseif iscell(mgen)
        mgenIndex = [];
        for i=1:length(mgen)
            mi = FindMorphogenIndex( mesh, mgen{i}, message );
            if ~isempty(mi)
                mgenIndex = [ mgenIndex mi ];
            end
        end
    end
end
