function h = makeCancelButton( fig, pos )
% h = makeCancelButton( fig, pos )
%   Make a standard Cancel button in the given figure at the given
%   position.  FIG can also be a uipanel handle.

    if nargin < 2
        pos = [20 20 60 20];
    end
    h = uicontrol( ...
            'Parent', fig, ...
            'Style', 'pushbutton', ...
            'Tag', 'cancelButton', ...
            'Units', 'pixels', 'Position', pos, ...
            'Callback', 'exitDialog(gcbo,false)', ...
            'FontWeight', 'bold', ...
            'String', 'Cancel' );
end
