function setview( theaxes, az, el, roll, camdistance )
%setview( theaxes, vp )
%setview( theaxes, az, el )
%setview( theaxes, az, el, roll )
%   Set the view parameters of the axes handle.
%   Either the whole view parameters structure can be given, or just
%   azimuth and elevation, or azimuth, elevation, and roll.

    if nargin==2
        vp = az;
    else
        cp = getCameraParams( theaxes );
        vp = ourViewParamsFromCameraParams( cp );
        if (nargin >= 2) && ~isempty(az)
            vp.azimuth = az;
        end
        if (nargin >= 3) && ~isempty(el)
            vp.elevation = el;
        end
        if (nargin >= 4) && ~isempty(roll)
            vp.roll = roll;
        end
        if (nargin >= 5) && ~isempty(camdistance)
            vp.camdistance = camdistance;
        end
    end
    cp = cameraParamsFromOurViewParams( vp );
    setCameraParams( theaxes, cp );
    h = guidata(theaxes);
    announceview( h, vp.azimuth, vp.elevation, vp.roll );
end
