function gc = baryToGlobalCoords( cells, bcs, nodes, triangles )
%gc = baryToGlobalCoords( cells, bcs, nodes, triangles )
%   Convert barycentric coordinates to global coordinates.
%   NODES is an N*D matrix containing the global coordinates of a set of N
%   points in D dimensions.
%   TRIANGLES is an M*3 matrix containing the indexes of triples of nodes.
%   CELLS is a C*1 or 1*C vector of indexes of triangles.
%   BCS is a C*3 array of barycentric coordinates.  bcs(i,:) is the
%   barycentric coordinates of a point in the triangle cells(i).
%   The result is a C*D array of global coordinates of all the given
%   points.
%
%   See also GLOBALTOBARYCOORDS.
%
%   Timing tests:
%       3.2 microseconds per point, for 100 points.
%       4 microseconds per point for 10 points.
%       20 microseconds per point for 1 point.

    gc = zeros( length(cells), 3 );
    
    % Note that we could write the body of the loop as
    %     gc(vi,:) = bcs(vi,:) * nodes( triangles( cells(vi), : ), : )
    % and omit the definition of cellVxs, but that is about 25% slower.
    cellVxs = triangles( cells, : );
    for vi=1:length(cells)
        gc(vi,:) = bcs(vi,:) * nodes( cellVxs( vi, : ), : );
    end
end
