function m = setInteractionMode( m, clickMode, varargin )
%m = setInteractionMode( m, clickMode, varargin )
%   Replace the current interaction mode by that specified by the arguments.
%   When clickMode is 'Current mgen' or 'Fixed mgen', varargin{1} is the index
%   of the selected morphogen, and varargin{2} is the amount.
fprintf( 1, 'setInteractionMode %s\n', clickMode );
    m = clearInteractionMode( m );
    m.interactionMode = struct( 'clickMode', clickMode );
    switch clickMode
        case { '----', 'morph----' }
            % Nothing.
        case { 'morphAdd', 'morphSet' }
            m.interactionMode.paintMorphogen = varargin{1};
            m.interactionMode.paintValue = varargin{2};
            m.interactionMode.savedMorphogen = m.morphogens( :, m.interactionMode.paintMorphogen );
        case 'morphFix'
            m.interactionMode.paintMorphogen = varargin{1};
            clampedVxs = find( m.morphogenclamp( :, varargin{1} )==1 );
            m = updateSelection( m, [], [], clampedVxs, 2 );
            % Redraw now?
        case 'Fix nodes'
            m.interactionMode.dfs = varargin{1};
            nodes = findConstrainedNodes( m, varargin{1} );
          % setInteractionMode_nodes = nodes'
            m = updateSelection( m, [], [], nodes, 2 );
            % Redraw now?
          % setInteractionMode_fem = m.selection
          % setInteractionMode_testnodes = findConstrainedNodes( m, m.interactionMode.dfs )
        case 'Locate node'
            m.interactionMode.dfs = varargin{1};
            if m.globalDynamicProps.locatenode==0
                selnodes = [];
            else
                selnodes = [m.globalDynamicProps.locatenode];
            end
            m = updateSelection( m, [], [], selnodes, 2 );
        case 'Seam edges'
            % NOT IMPLEMENTED.
        case 'Subdivide vertex'
            % NOT IMPLEMENTED.
        case 'Subdivide edge'
            % NOT IMPLEMENTED.
        case 'Subdivide element'
            % NOT IMPLEMENTED.
        case 'Elide edge'
            % NOT IMPLEMENTED.
        case 'Elide cell pair'
            % NOT IMPLEMENTED.
        otherwise
            % Nothing.
    end
end

function nodes = findConstrainedNodes( m, dfs )
    a = m.fixedDFmap(:,1:3) | m.fixedDFmap(:,4:6);
    a = a(:,1) + 2*a(:,2) + 4*a(:,3);
  % findConstrainedNodes_a = a'
    v = dfs.x + 2*dfs.y + 4*dfs.z;
  % findConstrainedNodes_v = v
    nodes = find( a==v );
end
