function mesh = setsaddlez(mesh,z,cycles)
%MESH = SETSADDLEZ(MESH,Z)  Apply saddle-shaped z-displacement of the points in
%P.
    if z==0, return; end
    if nargin < 3, cycles = 2; end

    mesh = makeTRIvalid( mesh );
    centre = sum( mesh.nodes, 1 )/size(mesh.nodes,1);
    
    x = mesh.nodes(:,1) - centre(1);
    y = mesh.nodes(:,2) - centre(2);
    if cycles==2
        newz = (x.*x - y.*y);
    else
        newz = ...
            (x.*x + y.*y) .* cos(atan2(y,x)*cycles);
    end
    newz = scalevec( newz, -z/2, z/2 );
    mesh = addToZ( mesh, newz );
end
