function c = findCloneVxCoords( mesh, vxs, mode )
%mesh = calcFEMcoords( mesh, vxs, mode )
%   Calculate the 3D coordinates of a list of clone vertexes.
%   If mode==0, the calculation is done on the mid-plane of the FEs.
%   If mode==-1 it is done on the A side, and if mode==1, the B side.

    if nargin < 2
        vxs = 1:length( mesh.secondlayer.vxFEMcell );
    end
    if nargin < 3
        mode = 0;
    end
    
    switch mode
        case -1
            nodes = mesh.prismnodes( 2:2:size(mesh.nodes,1), : );
        case 1
            nodes = mesh.prismnodes( 1:2:(size(mesh.nodes,1)-1), : );
        otherwise
            nodes = mesh.nodes;
    end
    c = baryToGlobalCoords( ...
            mesh.secondlayer.vxFEMcell(vxs), ...
            mesh.secondlayer.vxBaryCoords(vxs,:), ...
            nodes, ...
            mesh.tricellvxs );
end
