function [m,displacements] = restoreflatness( m, displacements )
    numpnodes = size( m.prismnodes, 1 );
    m.nodes = (m.prismnodes( 1:2:(numpnodes-1), : ) + m.prismnodes( 2:2:numpnodes, : ))/2;
    m.nodes(:,3) = 0;
    m.prismnodes( 1:2:(numpnodes-1), 1:2 ) = m.nodes(:,1:2);
    m.prismnodes( 2:2:numpnodes, 1:2 ) = m.nodes(:,1:2);
    if strcmp( m.globalProps.thicknessMode, 'scaled' )
        m.prismnodes( 1:2:(numpnodes-1), 3 ) = -m.globalDynamicProps.thicknessAbsolute/2;
        m.prismnodes( 2:2:numpnodes, 3 ) = m.globalDynamicProps.thicknessAbsolute/2;
    else
        verticals = m.prismnodes( 2:2:numpnodes, 3 ) - m.prismnodes( 1:2:(numpnodes-1), 3 );
        halfheights = sqrt( sum( verticals .* verticals, 2 ) )/2;
        m.prismnodes( 1:2:(numpnodes-1), 3 ) = -halfheights;
        m.prismnodes( 2:2:numpnodes, 3 ) = halfheights;
    end
    m.globalProps.trinodesvalid = true;
    m.globalProps.prismnodesvalid = true;
    if (nargin > 1) && (nargout > 1)
        displacements(:,3) = 0;
    end
    m = makeAreasAndNormals( m );
end
