function [mc,mcA,mcB] = meshColors( m )
    mc = getcolors( '' );
    if isempty( mc )
        mcA = getcolors( 'A' );
        mcB = getcolors( 'B' );
    else
        mcA = [];
        mcB = [];
    end

function mc = getcolors( suffix )
    fn = ['value' suffix];
    if isfield(m.plotdata,fn) && ~isempty(m.plotdata.(fn))
        mc = m.plotdata.(fn);
        if size(mc,2)==1
            if isfield( m.plotdata, 'cmap' ) && ~isempty( m.plotdata.cmap )
                cmap = m.plotdata.cmap;
            elseif ~isempty( m.plotdefaults.cmap )
                cmap = m.plotdefaults.cmap;
            else
                cmap = [];
            end
            if isempty(cmap)
                mc = [];
            else
                mc = interpolateArray( mc, ...
                                       cmap, ...
                                       m.plotdefaults.crange );
            end
        end
    else
        mc = [];
    end
end

end
