function result = isGFtboxProjectDir( pathname )
%result = isGFtboxProjectDir( pathname )
%   Returns TRUE or FALSE depending on whether PATHNAME is a path to a
%   GFtbox project directory.  The test is that the directory contain a
%   MAT-file whose basename is identical to the name of the directory.

    [parent,dirbasename] = fileparts( pathname );
    projectfilename = fullfile( pathname, [dirbasename, '.mat'] );
    result = exist( projectfilename, 'file' ) == 2;
end
