function gp = findPolGrad( m, cis )
%gp = findPolGrad( m, cis )
%   Calculate the polarising gradient for growth in the specified cells of
%   the mesh, by default all of them.

    if size( m.morphogens, 2 ) < 3
        return;
    end
    if nargin < 2
        cis = 1:size( m.tricellvxs, 1 );
    end
    
    setGlobals();
    global gOLD_K_POL
    global gNEW_POLARISER
    if m.versioninfo.mgenversion==0
        pol_mgen = gOLD_K_POL;
    else
        pol_mgen = gNEW_POLARISER;
    end
    
    gp = zeros(length(cis),3);
    for ci=1:length(cis)
        vxs = m.tricellvxs(cis(ci),:);
        gp(ci,:) = -trianglegradient( m.nodes( vxs, : ), ...
                                      m.morphogens( vxs, pol_mgen ) );
    end
end
