function [wts,pts] = edgesplinewts( m, ei, tension, bc )
    if nargin < 3
        tension = 1/16;
    end
    if nargin < 4
        bc = [0.5 0.5];
    end
    
    p1 = m.edgeends( ei, 1 );
    p2 = m.edgeends( ei, 2 );
    [e3,p3] = nextborderedge( m, ei, p1 );
    [e4,p4] = nextborderedge( m, ei, p2 );
    if (p3==0) || (p4==0)
        wts = bc;
        pts = [p1 p2];
    else
        wts = [0 bc 0] + tension*[-1 1 1 -1];
        pts = [p3 p1 p2 p4];
    end
end
