function m = deletecell(m,cellstodelete)
%m = deletecell(m,cellstodelete)    Delete finite elements from the mesh.

    if nargin==1, return; end
    if size(cellstodelete,2)==0, return; end
    
    numnodes = size(m.nodes,1);
    numedges = size(m.edgeends,1);
    numcells = size(m.tricellvxs,1);
    cellsBitMap = true(numcells,1);
    edgesBitMap = true(numedges,1);
    cellstodelete = unique(cellstodelete);
    cellsBitMap(cellstodelete) = false;
    if length(cellstodelete)==numcells
        fprintf( 1, 'Attempt to delete entire mesh ignored.\n' );
        return;
    end

    % Find all edges bordering the cells and set the relevant cell index to
    % zero.  Keep a list of edges that are to be deleted.
    numedgestodelete = 0;
    for cdi=1:length(cellstodelete)
        fi = cellstodelete(cdi);
        for fei=1:3
            ei = m.celledges(fi,fei);
            if m.edgecells(ei,2)==fi
                m.edgecells(ei,2) = 0;
            elseif m.edgecells(ei,1)==fi
                if m.edgecells(ei,2) == 0
                    m.edgecells(ei,1) = 0;
                    numedgestodelete = numedgestodelete+1;
                    edgesBitMap(ei) = false;
                else
                    m.edgecells(ei,:) = [m.edgecells(ei,2), 0];
                end
            end
        end
    end
    
    if numedgestodelete == 0
        nodesBitMap = [];
        edgesBitMap = [];
    else
        savednodes = m.edgeends(edgesBitMap,:);
        nodesBitMap(savednodes) = true;
    end
    
    if hasSecondLayer( m )
        m.secondlayer = deleteCellsInFEs( m.secondlayer, cellsBitMap );
    end
    
    m = renumberMesh( m, [], [], [], ...
                         nodesBitMap, edgesBitMap, cellsBitMap );
    
    m.saved = 0;
  
    % Check validity.
    validmesh(m);
end
