function m = convertBENDtoAB( m )
    if m.versioninfo.mgenversion == 1;
        return;
    end

    global gOLD_K_PAR gOLD_K_PER gOLD_K_POL;
    global gOLD_BEND_PAR gOLD_BEND_PER gOLD_BEND_POL;
    global gOLD_ARREST gOLD_STRAINRET gOLD_THICKNESS gOLD_NUMRESERVEDMGENS;
    global gNEW_NUMRESERVEDMGENS
    
    global gNEW_MorphogenNames

    [Apar,Bpar] = ab_from_kbend( ...
                    m.morphogens(:,gOLD_K_PAR), ...
                    m.morphogens(:,gOLD_BEND_PAR), ...
                    m.globalProps.allowNegativeGrowth );
    [Aper,Bper] = ab_from_kbend( ...
                    m.morphogens(:,gOLD_K_PER), ...
                    m.morphogens(:,gOLD_BEND_PER), ...
                    m.globalProps.allowNegativeGrowth );

    newmorphogens = [ ...
        Apar(:), ...
        Aper(:), ...
        Bpar(:), ...
        Bper(:), ...
        m.morphogens( :, gOLD_THICKNESS ), ...
        m.morphogens( :, gOLD_K_POL ) + m.morphogens( :, gOLD_BEND_POL ), ...
        m.morphogens( :, gOLD_STRAINRET ), ...
        m.morphogens( :, gOLD_ARREST )
    ];

    oldUserMgenRange = (gOLD_NUMRESERVEDMGENS+1):size(m.morphogens,2);
    m.morphogens = [ newmorphogens, m.morphogens( :, oldUserMgenRange ) ];
    m.morphogenclamp = [ zeros(size(newmorphogens)), m.morphogenclamp( :, oldUserMgenRange ) ];
    m.mgen_absorption = [ zeros(1,gNEW_NUMRESERVEDMGENS), m.mgen_absorption( :, oldUserMgenRange ) ];
    m.mgen_production = [ zeros(size(newmorphogens),gNEW_NUMRESERVEDMGENS), ...
                          m.mgen_production( :, oldUserMgenRange ) ];
    m.mutantLevel = [ ones(1,gNEW_NUMRESERVEDMGENS), m.mutantLevel( :, oldUserMgenRange ) ];
    m.mgenswitch = [ ones(1,gNEW_NUMRESERVEDMGENS), m.mgenswitch( :, oldUserMgenRange ) ];
    new_mgen_interpType = cell( 1, gNEW_NUMRESERVEDMGENS );
    for i=1:gNEW_NUMRESERVEDMGENS
        new_mgen_interpType{i} = 'mid';
    end
    m.mgen_interpType = { new_mgen_interpType{:}, m.mgen_interpType{oldUserMgenRange} };
    m.mgen_dilution = [ false(1,gNEW_NUMRESERVEDMGENS), ...
                        m.mgen_dilution( :, oldUserMgenRange ) ];
%{
    new_absKvector = m.absKvector( :, ...
        [ gOLD_K_PAR gOLD_K_PER gOLD_THICKNESS gOLD_K_POL ...
          gOLD_BEND_PAR gOLD_BEND_PER gOLD_BEND_PAR gOLD_BEND_PER ...
          gOLD_STRAINRET gOLD_ARREST ] );
%}
    parKvec = sum( m.absKvector( :, [ gOLD_K_PAR gOLD_BEND_PAR ] ), 2 )/2;
    perKvec = sum( m.absKvector( :, [ gOLD_K_PER gOLD_BEND_PER ] ), 2 )/2;
    new_absKvector = ...
        [ parKvec, perKvec, parKvec, perKvec, ...
          m.absKvector( :, [ gOLD_THICKNESS gOLD_K_POL ...
                             gOLD_STRAINRET gOLD_ARREST ] ) ];
    m.absKvector = [ new_absKvector, ...
                     m.absKvector( :, oldUserMgenRange ) ];
    m.mgenIndexToName = { gNEW_MorphogenNames{:}, m.mgenIndexToName{oldUserMgenRange} };
    m.mgenNameToIndex = invertDictionary( m.mgenIndexToName );
    
    m.versioninfo.mgenversion = 1;
    m = rewriteInteractionSkeleton( m, '', '', mfilename() );
end
