function MV = GetTransform6( M )
%function MV = GetTransform6( M )    Given a 3*3 linear transformation M,
%calculate the 6*6 matrix MV which is appropriate for
%transforming symmetric second rank tensors represented as 6-element
%vectors.

MV(1,1) = M(1,1)*M(1,1);
MV(1,2) = M(1,2)*M(1,2);
MV(1,3) = M(1,3)*M(1,3);
MV(2,1) = M(2,1)*M(2,1);
MV(2,2) = M(2,2)*M(2,2);
MV(2,3) = M(2,3)*M(2,3);
MV(3,1) = M(3,1)*M(3,1);
MV(3,2) = M(3,2)*M(3,2);
MV(3,3) = M(3,3)*M(3,3);

MV(1,4) = M(1,2)*M(1,3); % + M(1,3)*M(1,2);
MV(1,5) = M(1,1)*M(1,3); % + M(1,3)*M(1,1);
MV(1,6) = M(1,1)*M(1,2); % + M(1,2)*M(1,1);
MV(2,4) = M(2,2)*M(2,3); % + M(2,3)*M(2,2);
MV(2,5) = M(2,1)*M(2,3); % + M(2,3)*M(2,1);
MV(2,6) = M(2,1)*M(2,2); % + M(2,2)*M(2,1);
MV(3,4) = M(3,2)*M(3,3); % + M(3,3)*M(3,2);
MV(3,5) = M(3,1)*M(3,3); % + M(3,3)*M(3,1);
MV(3,6) = M(3,1)*M(3,2); % + M(3,2)*M(3,1);

MV(4,1) = M(2,1)*M(3,1); % + M(3,1)*M(2,1);
MV(4,2) = M(2,2)*M(3,2); % + M(3,2)*M(2,2);
MV(4,3) = M(2,3)*M(3,3); % + M(3,3)*M(2,3);
MV(5,1) = M(1,1)*M(3,1); % + M(3,1)*M(1,1);
MV(5,2) = M(1,2)*M(3,2); % + M(3,2)*M(1,2);
MV(5,3) = M(1,3)*M(3,3); % + M(3,3)*M(1,3);
MV(6,1) = M(1,1)*M(2,1); % + M(2,1)*M(1,1);
MV(6,2) = M(1,2)*M(2,2); % + M(2,2)*M(1,2);
MV(6,3) = M(1,3)*M(2,3); % + M(2,3)*M(1,3);

MV(4,4) = M(2,2)*M(3,3) + M(2,3)*M(3,2); % + M(3,2)*M(2,3) + M(3,3)*M(2,2);
MV(4,5) = M(2,1)*M(3,3) + M(2,3)*M(3,1); % + M(3,1)*M(2,3) + M(3,3)*M(2,1);
MV(4,6) = M(2,1)*M(3,2) + M(2,2)*M(3,1); % + M(3,1)*M(2,2) + M(3,2)*M(2,1);
MV(5,4) = M(1,2)*M(3,3) + M(1,3)*M(3,2); % + M(3,2)*M(1,3) + M(3,3)*M(1,2);
MV(5,5) = M(1,1)*M(3,3) + M(1,3)*M(3,1); % + M(3,1)*M(1,3) + M(3,3)*M(1,1);
MV(5,6) = M(1,1)*M(3,2) + M(1,2)*M(3,1); % + M(3,1)*M(1,2) + M(3,2)*M(1,1);
MV(6,4) = M(1,2)*M(2,3) + M(1,3)*M(2,2); % + M(2,2)*M(1,3) + M(2,3)*M(1,2);
MV(6,5) = M(1,1)*M(2,3) + M(1,3)*M(2,1); % + M(2,1)*M(1,3) + M(2,3)*M(1,1);
MV(6,6) = M(1,1)*M(2,2) + M(1,2)*M(2,1); % + M(2,1)*M(1,2) + M(2,2)*M(1,1);

return;

    MV(1,1) = M(1,1)*M(1,1);
    MV(2,2) = M(2,2)*M(2,2);
    MV(3,3) = M(3,3)*M(3,3);

    MV(1,2) = M(1,2)*M(1,2);
    MV(1,3) = M(1,3)*M(1,3);
    MV(2,3) = M(2,3)*M(2,3);

    MV(4,1) = 2*M(2,1)*M(3,1);
    MV(4,2) = 2*M(2,2)*M(3,2);
    MV(4,3) = 2*M(2,3)*M(3,3);

    MV(5,1) = 2*M(3,1)*M(1,1);
    MV(5,2) = 2*M(3,2)*M(1,2);
    MV(5,3) = 2*M(3,3)*M(1,3);

    MV(6,1) = 2*M(1,1)*M(2,1);
    MV(6,2) = 2*M(1,2)*M(2,2);
    MV(6,3) = 2*M(1,3)*M(2,3);

    MV(4,4) = 2*(M(2,2)*M(3,3) + M(2,3)*M(3,2));
    MV(5,5) = 2*(M(3,3)*M(1,1) + M(3,1)*M(1,3));
    MV(6,6) = 2*(M(1,1)*M(2,2) + M(1,2)*M(2,1));

    MV(4,5) = 2*(M(2,1)*M(3,3) + M(2,3)*M(3,1));
    MV(4,6) = 2*(M(3,1)*M(2,2) + M(3,2)*M(2,1));
    MV(5,6) = 2*(M(3,2)*M(1,1) + M(3,1)*M(1,2));

    for i=1:5
        for j=i+1:6
            MV(j,i) = MV(i,j);
        end
    end
end
