function fd = getFontDetails( h )
%fd = getFontDetails( h )
%   Find the font properties of the graphics handle h.  The result is a
%   structure with the fields FontName, FontUnits, FontSize, FontWeight,
%   and FontAngle.  All values are strings.  Missing fields are returned as
%   empty strings.

    fd.FontName = getField( h, 'FontName' );
    fd.FontUnits = getField( h, 'FontUnits' );
    fd.FontSize = getField( h, 'FontSize' );
    fd.FontWeight = getField( h, 'FontWeight' );
    fd.FontAngle = getField( h, 'FontAngle' );
end

function v = getField( h, f )
    try
        v = get( h, f );
    catch
        v = [];
    end
end
