function InitGFtboxPath()
% InitGFtboxPath()
%   Call this if you have never run GFtbox before. It will add all of the
%   GFtbox directories to your command path.  You must be in the main
%   GFtbox directory when you give this command.
%
%   This command only affects the path for the current Matlab session.  If
%   you want to have the GFtbox directories on the command path
%   permanently, then use the SAVEPATH command to save the current path.
%   This will avoid having to use the INITGFTBOX command again.
%
%   It is harmless, but unnecessary, to give this command if the GFtbox
%   directories are already on your command path.

% This function must only call functions which are either in this file, in
% the same directory, or in directories on the standard MATLAB command path.

    f = which('GFtbox.m');
    if isempty(f)
        fprintf( 1, ...
            ['%s: Cannot find GFtbox directory.  Find it manually, cd to it,\n', ...
             'and then give this command again.\n' ], ...
            mfilename() );
        return;
    end
    gftboxDir = fileparts(f);
    p = adddirstopath( gftboxDir, ...
        '[/\\]\.', ...
        '[/\\]Models', ...
        '[/\\]Motifs', ...
        '[/\\]temp', ...
        'GrowthToolbox[/\\]docs', ...
        'GrowthToolbox[/\\]Papers' );
    addpath(p);
%     y = split( ';', p );
%     for i=1:length(y)
%         fprintf( 1, '%s\n', y{i} );
%     end
    fprintf( 1, 'The GFtbox directories have been added to the MATLAB command path.\n' );
end

function dirs = adddirstopath( dirname, varargin )
%dirs = adddirstopath( dir, ... )
%   Add dir and all its subdirectories to the path, except for directories
%   matching any of the patterns given as subsequent arguments.

    x = genpath( dirname );
    dirlist = split( pathsep(), x );
    retain = true(1,length(dirlist));
    for i=1:length(dirlist)
        if isempty(dirlist{i})
            retain(i) = false;
        else
            for j=1:length(varargin)
                retain(i) = retain(i) && isempty( regexp( dirlist{i}, varargin{j} , 'once' ) );
            end
        end
    end
    dirs = joinstrings( pathsep(), { dirlist{retain} } );
end

function toks = split( pat, str )
%toks = split( pat, str )
%   Implementation of the Perl split() function.
%   Splits the string STR wherever the pattern PAT matches, and returns a
%   cell array of the strings between the matches.  If the string begins or
%   ends with a match, the cell array will correspondingly begin or end
%   with an empty string.

    if isempty(str)
        toks = {};
        return;
    end
    [ si, ei ] = regexp( str, pat, 'start', 'end' );
    si = [ (si-1), length(str) ];
    ei = [ 1 (ei+1) ];
    toks = cell(length(si),1);
    for i=1:length(si)
        toks{i} = str( ei(i):si(i) );
    end
end

function js = joinstrings( s, ss )
%js = joinstrings( s, ss )
%   ss is a cell array of strings.  Concatenate all members of ss together,
%   separated by the string s.

    if isempty(ss)
        js = '';
        return;
    end
    totlen = 0;
    for i=1:length(ss)
        totlen = totlen + length(ss{i});
    end
    totlen = totlen + length(s) * (length(ss)-1);
    js = char( zeros( 1, totlen ) );
    a = 1;
    b = length(ss{1});
    js(a:b) = ss{1};
    for i=2:length(ss)
        a = b+1;
        b = a+length(s)-1;
        js(a:b) = s;
        a = b+1;
        b = a+length(ss{i})-1;
        js(a:b) = ss{i};
    end
end