function setDisplayedGrowthMenuStrings( h )
    setGlobals();
    global gOLD_NUMRESERVEDMGENS;
    global gNEW_NUMRESERVEDMGENS;

    if isempty( h.mesh )
        set( h.displayedGrowthMenu, 'String', {''} );
        set( h.displayedGrowthMenu, 'Value', 1 );
        set( h.displayedGrowthMenu, 'UserData', [] );
    else
        if h.mesh.versioninfo.mgenversion==0
            NUMRESERVEDMGENS = gOLD_NUMRESERVEDMGENS;
        else
            NUMRESERVEDMGENS = gNEW_NUMRESERVEDMGENS;
        end
        mgenNames = h.mesh.mgenIndexToName;
        userIndexes = (NUMRESERVEDMGENS+1):length(mgenNames);
        xx = sort( {mgenNames{userIndexes}} );
        mgenNames = { mgenNames{1:NUMRESERVEDMGENS}, xx{:} };
        for i=1:length(mgenNames)
            menuIndexes.(mgenNames{i}) = i;
        end
        set( h.displayedGrowthMenu, 'UserData', menuIndexes );
        for i=1:NUMRESERVEDMGENS
            mgenNames{i} = [ '* ' mgenNames{i} ];
        end
        
        set( h.displayedGrowthMenu, 'String', mgenNames );
        currentMgen = FindMorphogenIndex( h.mesh, h.mesh.globalProps.displayedGrowth, '' );
        currentMgen = currentMgen(1);
        if (currentMgen < 1) || (currentMgen > length(get(h.displayedGrowthMenu, 'String')))
            h.mesh.plotdefaults.morphogen = 1;
        end
    end
end
