function m = completesecondlayer( m )
%m = completesecondlayer( m )
%   This takes a mesh having a second layer containing only the components
%       cells(:).vxs(:)
%       vxFEMcell(:)
%       vxBaryCoords(:,1:3)
%       cell3dcoords(:,1:3)
%   and calculates all the rest.

    m.secondlayer = calcEdgeData( m.secondlayer );
    m = setSplitThreshold( m, 1.05 );
    m.secondlayer.jiggleAmount = 0;
    m.secondlayer.generation = zeros( size(m.secondlayer.edges,1), 1 );
    m.secondlayer.cloneindex = ones(size( m.secondlayer.cells ));
    ok = checkclonesvalid( m.secondlayer );
    if ~ok
        % Delete the second layer?
        fprintf( 1, 'Second layer creation failed.\n' );
      % mesh = rmfield( mesh, 'm.secondlayer' );
    end
end
