function c = posnegMap( range, zerowhite, negpart, pospart )
    if nargin==0, range = [-1 1]; end
    range = extendToZero( range );
    if range(1)==range(2)
        c = [1 1 1
             1 1 1];
        return;
    end
    
    if nargin < 2
        zerowhite = true;
    end
    nsteps = 50;
    if zerowhite
        negfrac = range(1)/(range(1)-range(2));
        posfrac = range(2)/(range(2)-range(1));
        nneg = ceil(negfrac*nsteps);
        npos = ceil(posfrac*nsteps);
        maxfrac = max(negfrac,posfrac);
        negfrac = negfrac/maxfrac;
        posfrac = posfrac/maxfrac;
        if nneg==0
            posmap = makeCmap( pospart, npos+1, posfrac );
            c = posmap;
        elseif npos==0
            negmap = makeCmap( negpart, nneg, negfrac );
            c = negmap(size(negmap,1):-1:1,:);
        else
            negmap = makeCmap( negpart, nneg, negfrac );
            posmap = makeCmap( pospart, npos, posfrac );
            c = [ negmap(size(negmap,1):-1:1,:);
                  posmap(2:size(posmap,1),:) ];
        end
    else
        negpos = [ negpart( size(negpart,1):-1:1, : ); pospart ]; 
        c = makeCmap( negpos, nsteps, 1 );
    end
end
