function ph = plotSecondLayer( m )
%ph = plotSecondLayer( m )
%   Draw the second layer.

    numcells = length( m.secondlayer.cells );
    ph = zeros(2,numcells);
    
    if isempty( m.visible )
        visNodeMap = true( size(m.secondlayer.vxFEMcell) );
    else
        visNodeMap = m.visible.cells( m.secondlayer.vxFEMcell );
    end
    renumberNodes = 1:length(visNodeMap);
    renumberNodes(visNodeMap) = (1:sum(visNodeMap))';
    visCellMap = true( numcells, 1 );
    anodesmap = false( length(m.secondlayer.vxFEMcell), 1 );
    for ci=1:numcells
        cellnodes = m.secondlayer.cells(ci).vxs;
        visCellMap(ci) = all( visNodeMap(cellnodes) );
        a = m.secondlayer.side(ci);
        anodesmap( cellnodes ) = a;
    end
    bnodesmap = ~anodesmap;
    visCellIndexes = find(visCellMap);
    numviscells = length(visCellIndexes);
    visibleEdges = all( visNodeMap( m.secondlayer.edges(:,[1 2]) ), 2 );
    visEdgeSide1 = visCellMap( m.secondlayer.edges(:,3) );
    visEdgeSide2 = m.secondlayer.edges(:,4) ~= 0;
    for i=1:length(visEdgeSide2)
        ci = m.secondlayer.edges(i,4);
        visEdgeSide2(i) = (ci > 0) && visCellMap(ci);
    end
    visibleEdges = visibleEdges & (visEdgeSide1 | visEdgeSide2);
        
    h = guidata( m.pictures(1) );
    theaxes = h.picture;
    OFFSET = m.plotdefaults.layeroffset;
    if ~m.plotdefaults.drawleaf
        mids = m.nodes;
        offsets = 0;
    elseif m.plotdefaults.thick
        mids = 0.5 * (m.prismnodes( 2:2:(size(m.nodes,1)*2), : ) + ...
                      m.prismnodes( 1:2:(size(m.nodes,1)*2-1), : ));
        offsets = (0.5+OFFSET) ...
                    .* (m.prismnodes( 2:2:(size(m.nodes,1)*2), : ) - ...
                        m.prismnodes( 1:2:(size(m.nodes,1)*2-1), : ));
    else
        mids = m.nodes;
        offsets = OFFSET * (m.prismnodes( 2:2:(size(m.nodes,1)*2), : ) - ...
                          m.prismnodes( 1:2:(size(m.nodes,1)*2-1), : ));
    end
    if offsets==0
        c3dcoordsA = baryToGlobalCoords( ...
                        m.secondlayer.vxFEMcell(visNodeMap), ...
                        m.secondlayer.vxBaryCoords(visNodeMap,:), ...
                        mids, ...
                        m.tricellvxs );
    elseif m.plotdefaults.cellsonbothsides
        aviscellmap = true( 1, length(visCellMap) );
        bviscellmap = aviscellmap;
        c3dcoordsA = baryToGlobalCoords( ...
                        m.secondlayer.vxFEMcell(visNodeMap), ...
                        m.secondlayer.vxBaryCoords(visNodeMap,:), ...
                        mids-offsets, ...
                        m.tricellvxs );
        c3dcoordsB = baryToGlobalCoords( ...
                        m.secondlayer.vxFEMcell(visNodeMap), ...
                        m.secondlayer.vxBaryCoords(visNodeMap,:), ...
                        mids+offsets, ...
                        m.tricellvxs );
    else
        aviscellmap = m.secondlayer.side(visCellIndexes);
        bviscellmap = ~aviscellmap;
        avisnodesmap = visNodeMap & anodesmap;
        bvisnodesmap = visNodeMap & ~anodesmap;
        c3dcoordsA = baryToGlobalCoords( ...
                        m.secondlayer.vxFEMcell(avisnodesmap), ...
                        m.secondlayer.vxBaryCoords(avisnodesmap,:), ...
                        mids-offsets, ...
                        m.tricellvxs );
        c3dcoordsB = baryToGlobalCoords( ...
                        m.secondlayer.vxFEMcell(bvisnodesmap), ...
                        m.secondlayer.vxBaryCoords(bvisnodesmap,:), ...
                        mids+offsets, ...
                        m.tricellvxs );
    end
    if true
        maxvxs= 0;
        for ci=1:numviscells
            maxvxs = max( maxvxs, length( m.secondlayer.cells(visCellIndexes(ci)).vxs ) );
        end
        facearray = NaN(numviscells,maxvxs);
        for ci=1:numviscells
            vci = visCellIndexes(ci);
            facearray(ci,1:length( m.secondlayer.cells(vci).vxs )) = ...
                renumberNodes(m.secondlayer.cells(vci).vxs);
        end
      %  as = m.secondlayer.aside(
        if ~isempty(m.secondlayer.cellcolor)
            if m.plotdefaults.drawleaf
                vertices = [c3dcoordsA;c3dcoordsB];
                if m.plotdefaults.cellsonbothsides
                    bsideoffset = size(c3dcoordsA,1);
                    faces = [facearray; ...
                             facearray + bsideoffset];
                    colours = ...
                        [m.secondlayer.cellcolor(visCellMap,:); ...
                         m.secondlayer.cellcolor(visCellMap,:)];
                else
                    renumbernodesAB = [find(avisnodesmap); find(bvisnodesmap)];
                    faces = [facearray(aviscellmap,:); facearray(bviscellmap,:)];
                  % faces(~isnan(faces)) = renumbernodesAB( faces(~isnan(faces)) );
                    vertices(renumbernodesAB,:) = vertices;
                    colours = ...
                        [m.secondlayer.cellcolor(visCellMap & m.secondlayer.side(:),:); ...
                         m.secondlayer.cellcolor(visCellMap & ~m.secondlayer.side(:),:)];
                end
                ph = patch( ...
                        'Vertices', vertices, ...
                        'Faces', faces, ...
                        'FaceVertexCData', colours, ...
                        'FaceColor', 'flat', ...
                        'FaceAlpha', m.plotdefaults.bioAalpha, ...
                        'FaceLighting', m.plotdefaults.lightmode, ...
                        'AmbientStrength', m.plotdefaults.ambientstrength, ...
                        'EdgeColor', m.plotdefaults.bioAlinecolor, ...
                        'UserData', struct( 'biocell', ci ), ...
                        'LineStyle', 'none', ...
                        ... % 'LineWidth', m.plotdefaults.bioAlinesize, ...
                        'Parent', theaxes ...
                    );
            else
                ph = patch( ...
                        'Vertices', c3dcoordsA, ...
                        'Faces', facearray, ...
                        'FaceVertexCData', m.secondlayer.cellcolor(visCellMap,:), ...
                        'FaceColor', 'flat', ...
                        'FaceAlpha', m.plotdefaults.bioAalpha, ...
                        'FaceLighting', m.plotdefaults.lightmode, ...
                        'AmbientStrength', m.plotdefaults.ambientstrength, ...
                        'EdgeColor', m.plotdefaults.bioAlinecolor, ...
                        'UserData', struct( 'biocell', ci ), ...
                        'LineStyle', 'none', ...
                        ... % 'LineWidth', m.plotdefaults.bioAlinesize, ...
                        'Parent', theaxes ...
                    );
            end
        end
    else
        for ci=1:numviscells
            vci = visCellIndexes(ci);
            vxs = m.secondlayer.cells(vci).vxs;
            ph(1,ci) = plotSecondLayerCell( ...
                ci, c3dcoordsA( vxs, : ), m.secondlayer.cellcolor(vci,:), theaxes );
            ph(2,ci) = plotSecondLayerCell( ...
                ci, c3dcoordsB( vxs, : ), m.secondlayer.cellcolor(vci,:), theaxes );
        end
    end
    if m.plotdefaults.bioAlinesize > 0
        if m.plotdefaults.cellsonbothsides || ~m.plotdefaults.drawleaf
            renumberAnodes = renumberNodes;
            renumberBnodes = renumberNodes;
        else
            renumberAnodes = 1:length(anodesmap);
            renumberAnodes(anodesmap) = 1:sum(anodesmap);
            renumberBnodes = 1:length(bnodesmap);
            renumberBnodes(bnodesmap) = 1:sum(bnodesmap);
        end
        lineStyle = '-';
        genzero = m.secondlayer.generation==0;
        if m.plotdefaults.cellsonbothsides || ~m.plotdefaults.drawleaf
            aedgesmap = visibleEdges;
            bedgesmap = aedgesmap;
        else
            aedgesmap = visibleEdges & anodesmap(m.secondlayer.edges(:,1));
            bedgesmap = ~aedgesmap;
        end
        genzerovisA = genzero & aedgesmap;
        genposvisA = (~genzero) & aedgesmap;
        plotlines( theaxes, renumberAnodes(m.secondlayer.edges(genzerovisA,[1 2])), ...
            c3dcoordsA, ...
            'Color', m.plotdefaults.bioAlinecolor, ...
            'LineWidth', m.plotdefaults.bioAlinesize, ...
            'LineStyle', lineStyle );
        plotlines( theaxes, renumberAnodes(m.secondlayer.edges(genposvisA,[1 2])), ...
            c3dcoordsA, ...
            'Color', m.plotdefaults.bioAnewlinecolor, ...
            'LineWidth', m.plotdefaults.bioAlinesize, ...
            'LineStyle', lineStyle );
        if m.plotdefaults.drawleaf
            genzerovisB = genzero & bedgesmap;
            genposvisB = (~genzero) & bedgesmap;
            plotlines( theaxes, renumberBnodes(m.secondlayer.edges(genzerovisB,[1 2])), ...
                c3dcoordsB, ...
                'Color', m.plotdefaults.bioAlinecolor, ...
                'LineWidth', m.plotdefaults.bioAlinesize, ...
                'LineStyle', lineStyle );
            plotlines( theaxes, renumberBnodes(m.secondlayer.edges(genposvisB,[1 2])), ...
                c3dcoordsB, ...
                'Color', m.plotdefaults.bioAnewlinecolor, ...
                'LineWidth', m.plotdefaults.bioAlinesize, ...
                'LineStyle', lineStyle );
        end
    end
    
    if m.plotdefaults.bioApointsize > 0
        if m.plotdefaults.drawleaf
            plotpts( theaxes, [c3dcoordsA;c3dcoordsB], ...
                'Color', m.plotdefaults.bioApointcolor, ...
                'LineStyle', 'none', ...
                'Marker', '.', ...
                'MarkerSize', m.plotdefaults.bioApointsize );
        else
            plotpts( theaxes, c3dcoordsA, ...
                'Color', m.plotdefaults.bioApointcolor, ...
                'LineStyle', 'none', ...
                'Marker', '.', ...
                'MarkerSize', m.plotdefaults.bioApointsize );
        end
    end
end
