function Uplanar = planarCellStrain( U )
%Uplanar = planarCellStrain( U )
%   U is a 6*3 matrix of the displacements of the vertexes of a cell.
%   Rows 1:3 are one side, and rows 4:6 the other side.
%   Uplanar is set to the planar component of the strain, ignoring the
%   bending at the edges of the cell.

    Uplanar(1:3,:) = (U(1:3,:) + U(4:6,:))/2;
    Uplanar(4:6,:) = Uplanar(1:3,:);
end
