function moveOldRunsToNewRuns( modeldir )
%moveOldRunsToNewRuns( modeldir )
%
%   Move every subdirectory of modeldir/movies which contains a file called
%   "CommandLine.txt" to modeldir/runs.

    moviesdir = fullfile( modeldir, 'movies' );
    if ~exist( moviesdir, 'dir' )
        fprintf( 1, '%s: No movies dir %s\n', mfilename(), moviesdir );
        return;
    end
    xx = dir( moviesdir );
    tobemoved = false( 1, length(xx) );
    for i=1:length(xx)
        if xx(i).name(1) ~= '.'
            tobemoved(i) = exist( fullfile( fullfile( moviesdir, xx(i).name ), 'CommandLine.txt' ), 'file' );
        end
    end
    if ~any( tobemoved )
        fprintf( 1, '%s: Nothing needs to be moved.\n', mfilename() );
        return;
    end
    runsdir = fullfile( modeldir, 'runs' );
    if ~exist( runsdir, 'dir' )
        if exist( runsdir, 'file' )
            return;
        end
        fprintf( 1, '%s: Creating runs dir %s\n', mfilename(), runsdir );
        [success, msg, msgid] = mkdir( runsdir );
        if ~success
            fprintf( 1, '%s: Cannot create runs directory \n', mfilename(), runsdir );
            warning( msgid, msg );
            return;
        end
    end
    for i = 1:length( tobemoved )
        if tobemoved(i)
            oldrun = fullfile( moviesdir, xx(i).name );
            newrun = fullfile( runsdir, xx(i).name );
            fprintf( 1, '%s: Moving %s\n    to %s\n', mfilename(), oldrun, newrun );
            [success, msg, msgid] = movefile( oldrun, newrun, 'f' );
            if ~success
                fprintf( 1, '%s: Cannot move %s to %s\n', mfilename(), oldrun, newrun );
                warning( msgid, msg );
            end
        end
    end
end
