function mesh = fixNodeDFs( mesh, fixedDFs, mode )
%mesh = fixNodeDFs( mesh, fixedDFs )    Fix all the given degrees of
%   freedom.  fixedDFs is an N*s array in which each row contains the index
%   of a node of the triangular mesh and a degree of freedom (1=X, 2=Y, 3=Z).
%   MODE is 'add' to add the constraints to the existing constraints,
%   'replace' to replace all the existing constraints, and 'delete' to
%   remove these constraints from the existing constraints.  The default is
%   'replace'

%   Each node of the triangular mesh corresponds to two consecutive nodes
%   of the prism mesh.  Each node has three degrees of freedom.  Hence the
%   following calculation of fixedDFs.

    dfBase = (fixedDFs(:,1) - 1)*6;
    fixedDFs = dfBase + fixedDFs(:,2);
    fixedDFs = [ fixedDFs; (fixedDFs+3) ];
    
    if nargin < 3, mode = 'replace'; end
    
    switch mode
        case 'replace'
            mesh.globalProps.fixedDFs = fixedDFs;
        case 'add'
            mesh.globalProps.fixedDFs = union( fixedDFs, mesh.globalProps.fixedDFs );
        case 'delete'
            mesh.globalProps.fixedDFs = setdiff( mesh.globalProps.fixedDFs, fixedDFs );
    end
end
