function handles = drawHistoryImage( handles, xlo, xhi, ylo, yhi )
return;
    imageTile = handles.historyImage( ylo:yhi, xlo:xhi, : );
    imageTile = maskEdges( imageTile, 5 );
    image( imageTile, 'Parent', handles.historyPicture );
    set( handles.historyPicture, 'ButtonDownFcn', {@historyPicture_ButtonDownFcn} );
    historyPictureChildren = get( handles.historyPicture, 'Children' );
    set( historyPictureChildren, 'ButtonDownFcn', {@historyPicture_ButtonDownFcn} );
    set( handles.historyPicture, 'XTick', [] );
    set( handles.historyPicture, 'YTick', [] );
    set( handles.historyPicture, 'ZTick', [] );
    set( handles.historyPicture, 'Units', 'pixels' );
    set( handles.historyPicture, 'Tag', 'historyPicture' );
end

% --- Executes on mouse press over axes background.
function historyPicture_ButtonDownFcn(varargin)
    hitObject = varargin{1};
    handles = guidata( hitObject );
    if ~isfield( handles, 'historyImage' )
        return;
    end
    historyPictureChildren = get( handles.historyPicture, 'Children' );
    if isempty(historyPictureChildren)
        return;
    end 
    handles.mouseDownInHistory = 1;
    handles.mousetracking = 0;
    handles.newHistoryImageOffset = [0 0];
    handles.mouseStartPos = get( handles.output, 'CurrentPoint' );
    guidata( handles.output, handles );
end

function im = maskEdges( im, borderwidth )
    imheight = size(im,1);
    imwidth = size(im,2);
    desaturation = 0.3;
    mask = ones( size( im, 1 ), size( im, 2 ) );
    mask( 1:borderwidth, : ) = mask( 1:borderwidth, : ) * desaturation;
    mask( imheight-borderwidth+1:imheight, : ) = mask( imheight-borderwidth+1:imheight, : ) * desaturation;
    mask( :, 1:borderwidth ) = mask( :, 1:borderwidth ) * desaturation;
    mask( :, imwidth-borderwidth+1:imwidth ) = mask( :, imwidth-borderwidth+1:imwidth ) * desaturation;
    im(:,:,1) = 255 - uint8( double(255-im(:,:,1)) .* mask );
    im(:,:,2) = 255 - uint8( double(255-im(:,:,2)) .* mask );
    im(:,:,3) = 255 - uint8( double(255-im(:,:,3)) .* mask );
end
