function [m,ok] = leaf_semicircle( m, varargin )
%m = leaf_semicircle( m, ... )
%   Create a new semicircular mesh.  Parameters are as for leaf_circle.
%
%   Equivalent GUI operation: selecting "Semicircle" in the pulldown menu
%   in the "Mesh editor" panel and clicking the "New" button.
%
%   See also: LEAF_CIRCLE, LEAF_CYLINDER, LEAF_LEAF, LEAF_ONECELL,
%   LEAF_RECTANGLE.
%
%   Topics: Mesh creation.

    [m,ok] = leaf_circle( m, varargin{:} );
    if ok
        delvxs = find( m.nodes(:,2) < 0 );
        m = deletepoints( m, delvxs' );
        m.meshparams = safemakestruct( '', varargin );
        m.meshparams.randomness = 0;
        m.meshparams.type = regexprep( mfilename(), '^leaf_', '' );
    end
end
