function m = leaf_perturbz( m, varargin )
%m = leaf_perturbz( m, z, ... )
%   Add a random perturbation to the Z coordinate of every node.
%   Arguments:
%       A number z, the amplitude of the random displacement.  The
%       displacements will be randomly chosen from the interval -z/2 ...
%       z/2.
%   Options:
%       'absolute':   A boolean.  If true, then the displacements will be
%                     interpreted as alsolute distances.  If false (the
%                     default), they will be interpreted as amounts
%                     relative to the thickness at each point.
%   Example:
%       m = leaf_perturbz( m, 0.5, 'absolute', true )
%
%   Equivalent GUI operation: the "Random Z" button on the "Mesh editor"
%   panel. The amount of random deformation is specified by the value in
%   the upper of the two text boxes to the right of the button.  In the
%   GUI, 'absolute' is always assumed to be false.
%
%   Topics: Mesh editing.

    if isempty(m), return; end
    [ok1, amount, args] = getTypedArg( mfilename(), {'numeric'}, varargin );
    if ~ok1, return; end
    [s,ok] = safemakestruct( mfilename(), args );
    if ~ok, return; end
    s = defaultfields( s, 'absolute', false );
    ok = checkcommandargs( mfilename(), s, 'exact', 'absolute' );
    if ~ok, return; end

    m = perturbz( m, amount, s.absolute );
    m.meshparams.randomness = amount;
end

