function m = leaf_add_mgen( m, varargin ) % asasd
 %m = leaf_add_mgen( m, mgen_name, ... )
%   Add a new morphogen to m with the given name.  If there is already a
%   morphogen with that name, this command is ignored.  Any number of names
%   can be given at once.
%
%   Equivalent GUI operation: the "New" button on the "Morphogens" panel.
%   A dialog will appear in which the user chooses a name for the new
%   morphogen.
%
%   See also:
%       leaf_delete_mgen, leaf_rename_mgen
%
%   Topics: Morphogens.

    if isempty(m), return; end
    newMgenNames = {};
    firstNewMgenIndex = length(m.mgenIndexToName)+1;
    varargin = upper(varargin);
    for i=1:length(varargin)
        if ~ischar( varargin{i} )
            fprintf( 1, '%s: Morphogen names must be strings.\n', mfilename() );
        elseif isfield( m.mgenNameToIndex, varargin{i} )
            fprintf( 1, '%s: There is already a morphogen called "%s".\n', ...
                mfilename(), varargin{i} );
        else
            newMgenNames{ 1 + length(newMgenNames) } = varargin{i};
        end
    end

    if ~isempty(newMgenNames)
        numMgens = length(m.mgenIndexToName);
        newMgenIndexes = numMgens + (1:length(newMgenNames));
        for ai=1:length(newMgenNames)
            m.mgenIndexToName{numMgens+ai} = newMgenNames{ai};
            m.mgenNameToIndex.(newMgenNames{ai}) = numMgens+ai;
        end
        m = applyMgenDefaults( m, newMgenIndexes );
        m.plotdefaults.morphogen = firstNewMgenIndex;
        m = rewriteInteractionSkeleton( m, '', '', mfilename() );
        saveStaticPart( m );
    end
end
