function m = addStaticData( m, s )
%m = addStaticData( sd )
%   sd contains the static mesh data.  Overwrite the static data in m by sd
%   and reconcile them.  This mostly consists of replacing fields in m by
%   fields in sd, but the morphogen dictionary is shared by both and any
%   changes require reindexing the per-morphogen fields of m.

    s = upgradeStaticData( s, m );
    timeshift = s.globalProps.starttime - m.globalProps.starttime;
    if timeshift ~= 0
        m.globalDynamicProps.currenttime = timeshift + m.globalDynamicProps.currenttime;
    end
    dIndexToName = m.mgenIndexToName;
    dNameToIndex = m.mgenNameToIndex;
    sIndexToName = s.mgenIndexToName;
    sNameToIndex = s.mgenNameToIndex;
    numOldMgens = length(dIndexToName);
    numNewMgens = length(sIndexToName);
    m.globalProps = setFromStruct( m.globalProps, s.globalProps );
    m.plotdefaults = setFromStruct( m.plotdefaults, s.plotdefaults );
    s = rmfield( s, {'globalProps','plotdefaults'} );
    m = setFromStruct( m, s );
    newtoold = zeros(1,length(sIndexToName));
    for newindex=1:length(sIndexToName)
        try
            oldindex = dNameToIndex.(sIndexToName{newindex});
        catch
            oldindex = 0;
        end
        newtoold(newindex) = oldindex;
    end
    if (length(newtoold)==length(dIndexToName)) && all( newtoold==(1:length(dIndexToName)) )
        % No change in morphogens.
        return;
    end
    
    oldtonew = zeros(1,length(dIndexToName));
    for oldindex=1:length(dIndexToName)
        try
            newindex = sNameToIndex.(dIndexToName{oldindex});
        catch
            newindex = 0;
        end
        oldtonew(oldindex) = newindex;
    end
    
    % Need to reconcile old and new morphogens.
    retainedMgens = oldtonew ~= 0;
    numRetainedMgens = sum(retainedMgens);
    numExtraMgens = numNewMgens - numRetainedMgens;
    extraMgens = find( newtoold==0 );
    perm( 1:numRetainedMgens ) = oldtonew(retainedMgens);
    perm( (numRetainedMgens+1):(numRetainedMgens+numExtraMgens) ) = extraMgens;
    
    % Reindex the morphogens and fill in new morphogens with zeros.
    retainedMgens = oldtonew ~= 0;
    numnodes = size(m.nodes,1);
    m.morphogens(:,perm) = [ m.morphogens(:,retainedMgens), zeros( numnodes, numExtraMgens ) ];
    m.morphogenclamp(:,perm) = [ m.morphogenclamp(:,retainedMgens), zeros( numnodes, numExtraMgens ) ];
    m.mgen_production(:,perm) = [ m.mgen_production(:,retainedMgens), zeros( numnodes, numExtraMgens ) ];
    m.mutantLevel(perm) = [ m.mutantLevel(retainedMgens), ones( 1, numExtraMgens ) ];
    m.mgenswitch(perm) = [ m.mgenswitch(retainedMgens), ones( 1, numExtraMgens ) ];
    m.transportfield(perm) = [ m.transportfield(retainedMgens), cell( 1, numExtraMgens ) ];
    %m.mgen_dilution(perm) = [ m.mgen_dilution(retainedMgens), ones( 1, numExtraMgens ) ];
    %m.mgen_transportable(perm) = [ m.mgen_transportable(retainedMgens), ones( 1, numExtraMgens ) ];
    if numNewMgens < numOldMgens
        deletedRange = (numNewMgens+1):numOldMgens;
        m.morphogens(:,deletedRange) = [];
        m.morphogenclamp(:,deletedRange) = [];
        m.mgen_production(:,deletedRange) = [];
        m.mutantLevel(deletedRange) = [];
        m.mgenswitch(deletedRange) = [];
    %    m.mgen_dilution(deletedRange) = [];
    %    m.mgen_transportable(deletedRange) = [];
    end
    % Similarly for everything else in the dynamic part that is indexed
    % by morphogen.  TO BE COMPLETED.
end

