function [tokenstream,token] = readtoken( tokenstream )
%[tokenstream,token] = readtoken( tokenstream )
%   Read a token from a stream.  At end of stream, the empty string will be
%   returned and the underlying file will be closed.
    if tokenstream.curtok <= length(tokenstream.tokens)
        token = tokenstream.tokens{tokenstream.curtok};
        if tokenstream.curtok == length(tokenstream.tokens)
            tokenstream.curtok = 1;
            tokenstream.tokens = {};
        else
            tokenstream.curtok = tokenstream.curtok+1;
        end
    else
        tokenstream = refillbuffer( tokenstream );
        if ~isempty(tokenstream.tokens)
            token = tokenstream.tokens{1};
            if length(tokenstream.tokens)==1
                tokenstream.tokens = {};
            else
                tokenstream.curtok = 2;
            end
        else
            token = '';
        end
    end
end
