function [ok,missingfields,extrafields] = checkFields( s, requiredfields, optionalfields )
%ok = checkFields( s, requiredfields, optionalfields )
%   Check that the structure s has all the required fields, and nothing
%   else except the optional fields.

    ok = true;
    missingfields = {};
    for i=1:length(requiredfields)
        if ~isfield( s, requiredfields{i} )
            ok = false;
            missingfields{end+1} = requiredfields{i};
        end
    end
    teststruct = struct();
    for i=1:length(requiredfields)
        teststruct.(requiredfields{i}) = [];
    end
    for i=1:length(optionalfields)
        teststruct.(optionalfields{i}) = [];
    end
    fn = fieldnames(s);
    extrafields = {};
    for i=1:length(fn)
        if ~isfield( teststruct, fn{i} )
            ok = false;
            extrafields{end+1} = fn{i};
        end
    end
end
