function c = randcolor( n, hsv1, hsv2 ) % hue, saturation, brightness )
%c = randcolor( n, hsv1, hsv2 )
%   Generate n random colors as an N*3 matrix of RGB values.
%   hsv1 and hsv2 are two colors in HSV space.
%   The resulting colours will be distributed in the box of HSV space
%   bounded by these two colours.

    spread = 0.2;
    h = spreadHue( randInRange( n, unspreadHue( [hsv1(1) hsv2(1)], spread ) ), spread );
    s = sqrt( randInRange( n, [hsv1(2) hsv2(2)].^2 ) );
    b = randInRange( n, [hsv1(3) hsv2(3)].^3 ).^0.333333;
    c = HSVtoRGB( h, s, b );
end

function v = randInRange( n, r )
    switch length(r)
        case 0
            v = rand(n,1);
        case 1
            v = ones(n,1) * r;
        case 2
            v = rand(n,1) * (r(2)-r(1)) + r(1);
    end
end

