/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.LocalException;
import Ice.Logger;
import IceInternal.Connector;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TcpTransceiver;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;

final class TcpConnector
implements Connector,
Comparable {
    private Instance _instance;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private InetSocketAddress _addr;
    private int _timeout;
    private String _connectionId = "";
    private int _hashCode;

    public Transceiver connect() {
        if (this._traceLevels.network >= 2) {
            String s = "trying to establish tcp connection to " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        try {
            SocketChannel fd = Network.createTcpSocket();
            Network.setBlock(fd, false);
            Network.setTcpBufSize(fd, this._instance.initializationData().properties, this._logger);
            boolean connected = Network.doConnect(fd, this._addr);
            if (connected && this._traceLevels.network >= 1) {
                String s = "tcp connection established\n" + Network.fdToString(fd);
                this._logger.trace(this._traceLevels.networkCat, s);
            }
            return new TcpTransceiver(this._instance, fd, connected);
        }
        catch (LocalException ex) {
            if (this._traceLevels.network >= 2) {
                String s = "failed to establish tcp connection to " + this.toString() + "\n" + ex;
                this._logger.trace(this._traceLevels.networkCat, s);
            }
            throw ex;
        }
    }

    public short type() {
        return 1;
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    public int hashCode() {
        return this._hashCode;
    }

    TcpConnector(Instance instance, InetSocketAddress addr, int timeout, String connectionId) {
        this._instance = instance;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.initializationData().logger;
        this._addr = addr;
        this._timeout = timeout;
        this._connectionId = connectionId;
        this._hashCode = this._addr.getAddress().getHostAddress().hashCode();
        this._hashCode = 5 * this._hashCode + this._addr.getPort();
        this._hashCode = 5 * this._hashCode + this._timeout;
        this._hashCode = 5 * this._hashCode + this._connectionId.hashCode();
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        TcpConnector p;
        block10: {
            p = null;
            try {
                p = (TcpConnector)obj;
            }
            catch (ClassCastException ex) {
                try {
                    Connector c = (Connector)obj;
                    return this.type() < c.type() ? -1 : 1;
                }
                catch (ClassCastException ee) {
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError();
                }
            }
        }
        if (this == p) {
            return 0;
        }
        if (this._timeout < p._timeout) {
            return -1;
        }
        if (p._timeout < this._timeout) {
            return 1;
        }
        if (!this._connectionId.equals(p._connectionId)) {
            return this._connectionId.compareTo(p._connectionId);
        }
        if (this._timeout < p._timeout) {
            return -1;
        }
        if (p._timeout < this._timeout) {
            return 1;
        }
        return Network.compareAddress(this._addr, p._addr);
    }

    protected synchronized void finalize() throws Throwable {
        super.finalize();
    }
}

