/*
 * Decompiled with CFR 0.152.
 */
package IceBox;

import Ice.Application;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.Current;
import Ice.Identity;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.Logger;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.Properties;
import Ice.StringSeqHolder;
import Ice.Util;
import Ice._PropertiesAdminDisp;
import IceBox.AMI_ServiceObserver_servicesStarted;
import IceBox.AMI_ServiceObserver_servicesStopped;
import IceBox.AlreadyStartedException;
import IceBox.AlreadyStoppedException;
import IceBox.FailureException;
import IceBox.NoSuchServiceException;
import IceBox.Service;
import IceBox.ServiceObserverPrx;
import IceBox.SliceChecksums;
import IceBox._ServiceManagerDisp;
import IceUtilInternal.Options;
import IceUtilInternal.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerI
extends _ServiceManagerDisp {
    public static final int StatusStopping = 0;
    public static final int StatusStopped = 1;
    public static final int StatusStarting = 2;
    public static final int StatusStarted = 3;
    private Application _server;
    private Communicator _sharedCommunicator;
    private Logger _logger;
    private String[] _argv;
    private List<ServiceInfo> _services = new LinkedList<ServiceInfo>();
    private boolean _pendingStatusChanges = false;
    HashSet<ServiceObserverPrx> _observers = new HashSet();
    int _traceServiceObserver = 0;

    public ServiceManagerI(Application server, String[] args) {
        this._server = server;
        ServiceManagerI serviceManagerI = this;
        this._logger = serviceManagerI._server.communicator().getLogger();
        this._argv = args;
        ServiceManagerI serviceManagerI2 = this;
        this._traceServiceObserver = serviceManagerI2._server.communicator().getProperties().getPropertyAsInt("IceBox.Trace.ServiceObserver");
    }

    public Map getSliceChecksums(Current current) {
        return SliceChecksums.checksums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startService(String name, Current current) throws AlreadyStartedException, NoSuchServiceException {
        ServiceInfo info = null;
        ServiceManagerI serviceManagerI = this;
        synchronized (serviceManagerI) {
            for (ServiceInfo in : this._services) {
                if (!in.name.equals(name)) continue;
                if (in.status == 3) {
                    throw new AlreadyStartedException();
                }
                in.status = 2;
                info = (ServiceInfo)in.clone();
                break;
            }
            if (info == null) {
                throw new NoSuchServiceException();
            }
            this._pendingStatusChanges = true;
        }
        boolean started = false;
        try {
            Communicator communicator;
            Service service = info.service;
            if (info.communicator == null) {
                ServiceManagerI serviceManagerI2 = this;
                communicator = serviceManagerI2._server.communicator();
            } else {
                communicator = info.communicator;
            }
            service.start(name, communicator, info.args);
            started = true;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            this._logger.warning("ServiceManager: exception in start for service " + info.name + "\n" + sw.toString());
        }
        Object observers = null;
        ServiceManagerI serviceManagerI3 = this;
        synchronized (serviceManagerI3) {
            for (ServiceInfo in : this._services) {
                if (!in.name.equals(name)) continue;
                if (started) {
                    in.status = 3;
                    ArrayList<String> services = new ArrayList<String>();
                    services.add(name);
                    this.servicesStarted(services, this._observers);
                    break;
                }
                in.status = 1;
                break;
            }
            this._pendingStatusChanges = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService(String name, Current current) throws AlreadyStoppedException, NoSuchServiceException {
        ServiceInfo info = null;
        ServiceManagerI serviceManagerI = this;
        synchronized (serviceManagerI) {
            for (ServiceInfo in : this._services) {
                if (!in.name.equals(name)) continue;
                if (in.status == 1) {
                    throw new AlreadyStoppedException();
                }
                in.status = 0;
                info = (ServiceInfo)in.clone();
                break;
            }
            if (info == null) {
                throw new NoSuchServiceException();
            }
            this._pendingStatusChanges = true;
        }
        boolean stopped = false;
        try {
            info.service.stop();
            stopped = true;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            this._logger.warning("ServiceManager: exception in stop for service " + info.name + "\n" + sw.toString());
        }
        ServiceManagerI serviceManagerI2 = this;
        synchronized (serviceManagerI2) {
            for (ServiceInfo in : this._services) {
                if (!in.name.equals(name)) continue;
                if (stopped) {
                    in.status = 1;
                    ArrayList<String> services = new ArrayList<String>();
                    services.add(name);
                    this.servicesStopped(services, this._observers);
                    break;
                }
                in.status = 3;
                break;
            }
            this._pendingStatusChanges = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(final ServiceObserverPrx observer, Current current) {
        LinkedList<String> activeServices = new LinkedList<String>();
        ServiceManagerI serviceManagerI = this;
        synchronized (serviceManagerI) {
            if (observer != null && this._observers.add(observer)) {
                if (this._traceServiceObserver >= 1) {
                    ServiceManagerI serviceManagerI2 = this;
                    this._logger.trace("IceBox.ServiceObserver", "Added service observer " + serviceManagerI2._server.communicator().proxyToString(observer));
                }
                for (ServiceInfo info : this._services) {
                    if (info.status != 3) continue;
                    activeServices.add(info.name);
                }
            }
        }
        if (activeServices.size() > 0) {
            AMI_ServiceObserver_servicesStarted cb = new AMI_ServiceObserver_servicesStarted(){

                public void ice_response() {
                }

                public void ice_exception(LocalException ex) {
                    ServiceManagerI.this.removeObserver(observer, ex);
                }
            };
            observer.servicesStarted_async(cb, activeServices.toArray(new String[0]));
        }
    }

    @Override
    public void shutdown(Current current) {
        ServiceManagerI serviceManagerI = this;
        serviceManagerI._server.communicator().shutdown();
    }

    public int run() {
        try {
            ServiceManagerI serviceManagerI = this;
            Properties properties = serviceManagerI._server.communicator().getProperties();
            ObjectAdapter adapter = null;
            if (!properties.getProperty("IceBox.ServiceManager.Endpoints").equals("")) {
                ServiceManagerI serviceManagerI2 = this;
                adapter = serviceManagerI2._server.communicator().createObjectAdapter("IceBox.ServiceManager");
                Identity identity = new Identity();
                identity.category = properties.getPropertyWithDefault("IceBox.InstanceName", "IceBox");
                identity.name = "ServiceManager";
                adapter.add(this, identity);
            }
            String prefix = "IceBox.Service.";
            Map<String, String> services = properties.getPropertiesForPrefix("IceBox.Service.");
            String[] loadOrder = properties.getPropertyAsList("IceBox.LoadOrder");
            for (int i = 0; i < loadOrder.length; ++i) {
                if (loadOrder[i].length() <= 0) continue;
                String key = "IceBox.Service." + loadOrder[i];
                String value = services.get(key);
                if (value == null) {
                    FailureException ex = new FailureException();
                    ex.reason = "ServiceManager: no service definition for `" + loadOrder[i] + "'";
                    throw ex;
                }
                this.load(loadOrder[i], value);
                services.remove(key);
            }
            for (Map.Entry<String, String> entry : services.entrySet()) {
                String name = entry.getKey().substring("IceBox.Service.".length());
                String value = entry.getValue();
                this.load(name, value);
            }
            String bundleName = properties.getProperty("IceBox.PrintServicesReady");
            if (bundleName.length() > 0) {
                System.out.println(bundleName + " ready");
            }
            ServiceManagerI serviceManagerI3 = this;
            serviceManagerI3._server.shutdownOnInterrupt();
            try {
                ServiceManagerI serviceManagerI4 = this;
                serviceManagerI4._server.communicator().addAdminFacet(this, "IceBox.ServiceManager");
                for (ServiceInfo info : this._services) {
                    Communicator communicator = info.communicator != null ? info.communicator : this._sharedCommunicator;
                    ServiceManagerI serviceManagerI5 = this;
                    serviceManagerI5._server.communicator().addAdminFacet(new PropertiesAdminI(communicator.getProperties()), "IceBox.Service." + info.name + ".Properties");
                }
                ServiceManagerI serviceManagerI6 = this;
                serviceManagerI6._server.communicator().getAdmin();
            }
            catch (ObjectAdapterDeactivatedException ex) {
                // empty catch block
            }
            if (adapter != null) {
                try {
                    adapter.activate();
                }
                catch (ObjectAdapterDeactivatedException ex) {
                    // empty catch block
                }
            }
            ServiceManagerI serviceManagerI7 = this;
            serviceManagerI7._server.communicator().waitForShutdown();
            ServiceManagerI serviceManagerI8 = this;
            serviceManagerI8._server.defaultInterrupt();
            this.stopAll();
        }
        catch (FailureException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println(ex.reason);
            ex.printStackTrace(pw);
            pw.flush();
            this._logger.error(sw.toString());
            this.stopAll();
            return 1;
        }
        catch (LocalException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            this._logger.error("ServiceManager: " + ex + "\n" + sw.toString());
            this.stopAll();
            return 1;
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            this._logger.error("ServiceManager: unknown exception\n" + sw.toString());
            this.stopAll();
            return 1;
        }
        return 0;
    }

    private void load(String name, String value) throws FailureException {
        String[] args;
        String className;
        int pos = StringUtil.findFirstOf(value, " \t\n");
        if (pos == -1) {
            className = value;
            args = new String[]{};
        } else {
            className = value.substring(0, pos);
            try {
                args = Options.split(value.substring(pos));
            }
            catch (Options.BadQuote ex) {
                FailureException e = new FailureException();
                e.reason = "ServiceManager: invalid arguments for service `" + name + "':\n" + ex.toString();
                throw e;
            }
        }
        this.start(name, className, args);
    }

    private synchronized void start(String service, String className, String[] args) throws FailureException {
        int j;
        ArrayList<String> l = new ArrayList<String>();
        for (j = 0; j < args.length; ++j) {
            l.add(args[j]);
        }
        for (j = 0; j < this._argv.length; ++j) {
            if (!this._argv[j].startsWith("--" + service + ".")) continue;
            l.add(this._argv[j]);
        }
        StringSeqHolder serviceArgs = new StringSeqHolder();
        serviceArgs.value = l.toArray(new String[0]);
        ServiceInfo info = new ServiceInfo();
        info.name = service;
        info.status = 1;
        try {
            Class<?> c = Class.forName(className);
            Object obj = c.newInstance();
            try {
                info.service = (Service)obj;
            }
            catch (ClassCastException ex) {
                FailureException e = new FailureException();
                e.reason = "ServiceManager: class " + className + " does not implement IceBox.Service";
                throw e;
            }
        }
        catch (ClassNotFoundException ex) {
            FailureException e = new FailureException();
            e.reason = "ServiceManager: class " + className + " not found";
            e.initCause(ex);
            throw e;
        }
        catch (IllegalAccessException ex) {
            FailureException e = new FailureException();
            e.reason = "ServiceManager: unable to access default constructor in class " + className;
            e.initCause(ex);
            throw e;
        }
        catch (InstantiationException ex) {
            FailureException e = new FailureException();
            e.reason = "ServiceManager: unable to instantiate class " + className;
            e.initCause(ex);
            throw e;
        }
        try {
            Communicator communicator;
            ServiceManagerI serviceManagerI = this;
            if (serviceManagerI._server.communicator().getProperties().getPropertyAsInt("IceBox.UseSharedCommunicator." + service) > 0) {
                if (this._sharedCommunicator == null) {
                    this._sharedCommunicator = this.createCommunicator("", new StringSeqHolder());
                }
                communicator = this._sharedCommunicator;
                Properties properties = this._sharedCommunicator.getProperties();
                Properties svcProperties = Util.createProperties(serviceArgs, properties);
                Map<String, String> allProps = properties.getPropertiesForPrefix("");
                for (String key : allProps.keySet()) {
                    if (svcProperties.getProperty(key).length() != 0) continue;
                    properties.setProperty(key, "");
                }
                for (Map.Entry<String, String> entry : svcProperties.getPropertiesForPrefix("").entrySet()) {
                    properties.setProperty(entry.getKey(), entry.getValue());
                }
                serviceArgs.value = properties.parseCommandLineOptions(service, serviceArgs.value);
            } else {
                communicator = info.communicator = this.createCommunicator(service, serviceArgs);
            }
            try {
                info.args = serviceArgs.value;
                info.service.start(service, communicator, info.args);
                info.status = 3;
            }
            catch (Throwable ex) {
                if (info.communicator != null) {
                    PrintWriter pw;
                    StringWriter sw;
                    try {
                        info.communicator.shutdown();
                        info.communicator.waitForShutdown();
                    }
                    catch (CommunicatorDestroyedException e) {
                    }
                    catch (Exception e) {
                        sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        pw.flush();
                        this._logger.warning("ServiceManager: exception in shutting down communicator for service " + service + "\n" + sw.toString());
                    }
                    try {
                        info.communicator.destroy();
                    }
                    catch (Exception e) {
                        sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        pw.flush();
                        this._logger.warning("ServiceManager: exception in destroying communciator for service" + service + "\n" + sw.toString());
                    }
                }
                throw ex;
            }
            this._services.add(info);
        }
        catch (FailureException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            FailureException e = new FailureException();
            e.reason = "ServiceManager: exception while starting service " + service + ": " + ex;
            e.initCause(ex);
            throw e;
        }
    }

    private synchronized void stopAll() {
        while (this._pendingStatusChanges) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        ArrayList<String> stoppedServices = new ArrayList<String>();
        ListIterator<ServiceInfo> p = this._services.listIterator(this._services.size());
        while (p.hasPrevious()) {
            PrintWriter pw;
            StringWriter sw;
            ServiceInfo info = p.previous();
            if (info.status == 3) {
                try {
                    info.service.stop();
                    info.status = 1;
                    stoppedServices.add(info.name);
                }
                catch (Exception e) {
                    sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    pw.flush();
                    this._logger.warning("ServiceManager: exception in stop for service " + info.name + "\n" + sw.toString());
                }
            }
            try {
                ServiceManagerI serviceManagerI = this;
                serviceManagerI._server.communicator().removeAdminFacet("IceBox.Service." + info.name + ".Properties");
            }
            catch (LocalException e) {
                // empty catch block
            }
            if (info.communicator == null) continue;
            try {
                info.communicator.shutdown();
                info.communicator.waitForShutdown();
            }
            catch (CommunicatorDestroyedException e) {
            }
            catch (Exception e) {
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                this._logger.warning("ServiceManager: exception in stop for service " + info.name + "\n" + sw.toString());
            }
            try {
                info.communicator.destroy();
            }
            catch (Exception e) {
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                this._logger.warning("ServiceManager: exception in stop for service " + info.name + "\n" + sw.toString());
            }
        }
        if (this._sharedCommunicator != null) {
            try {
                this._sharedCommunicator.destroy();
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                this._logger.warning("ServiceManager: unknown exception while destroying shared communicator:\n" + sw.toString());
            }
            this._sharedCommunicator = null;
        }
        this._services.clear();
        this.servicesStopped(stoppedServices, this._observers);
    }

    private void servicesStarted(List<String> services, Set<ServiceObserverPrx> observers) {
        if (services.size() > 0) {
            String[] servicesArray = services.toArray(new String[0]);
            for (final ServiceObserverPrx observer : observers) {
                AMI_ServiceObserver_servicesStarted cb = new AMI_ServiceObserver_servicesStarted(){

                    public void ice_response() {
                    }

                    public void ice_exception(LocalException ex) {
                        ServiceManagerI.this.removeObserver(observer, ex);
                    }
                };
                observer.servicesStarted_async(cb, servicesArray);
            }
        }
    }

    private void servicesStopped(List<String> services, Set<ServiceObserverPrx> observers) {
        if (services.size() > 0) {
            String[] servicesArray = services.toArray(new String[0]);
            for (final ServiceObserverPrx observer : observers) {
                AMI_ServiceObserver_servicesStopped cb = new AMI_ServiceObserver_servicesStopped(){

                    public void ice_response() {
                    }

                    public void ice_exception(LocalException ex) {
                        ServiceManagerI.this.removeObserver(observer, ex);
                    }
                };
                observer.servicesStopped_async(cb, servicesArray);
            }
        }
    }

    private synchronized void removeObserver(ServiceObserverPrx observer, LocalException ex) {
        if (this._observers.remove(observer)) {
            this.observerRemoved(observer, ex);
        }
    }

    private void observerRemoved(ServiceObserverPrx observer, RuntimeException ex) {
        if (this._traceServiceObserver >= 1 && !(ex instanceof CommunicatorDestroyedException)) {
            ServiceManagerI serviceManagerI = this;
            this._logger.trace("IceBox.ServiceObserver", "Removed service observer " + serviceManagerI._server.communicator().proxyToString(observer) + "\nafter catching " + ex.toString());
        }
    }

    private Communicator createCommunicator(String service, StringSeqHolder args) {
        Properties properties;
        ServiceManagerI serviceManagerI = this;
        Properties communicatorProperties = serviceManagerI._server.communicator().getProperties();
        if (communicatorProperties.getPropertyAsInt("IceBox.InheritProperties") > 0) {
            properties = communicatorProperties._clone();
            properties.setProperty("Ice.Admin.Endpoints", "");
        } else {
            properties = Util.createProperties();
        }
        String programName = communicatorProperties.getProperty("Ice.ProgramName");
        if (service.length() == 0) {
            if (programName.length() == 0) {
                properties.setProperty("Ice.ProgramName", "SharedCommunicator");
            } else {
                properties.setProperty("Ice.ProgramName", programName + "-SharedCommunicator");
            }
        } else if (programName.length() == 0) {
            properties.setProperty("Ice.ProgramName", service);
        } else {
            properties.setProperty("Ice.ProgramName", programName + "-" + service);
        }
        if (args.value != null && args.value.length > 0) {
            properties = Util.createProperties(args, properties);
            if (service.length() > 0) {
                args.value = properties.parseCommandLineOptions(service, args.value);
            }
        }
        InitializationData initData = new InitializationData();
        initData.properties = properties;
        if (args.value != null) {
            return Util.initialize(args, initData);
        }
        return Util.initialize(initData);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertiesAdminI
    extends _PropertiesAdminDisp {
        private final Properties _properties;

        PropertiesAdminI(Properties properties) {
            this._properties = properties;
        }

        @Override
        public String getProperty(String name, Current current) {
            return this._properties.getProperty(name);
        }

        public TreeMap<String, String> getPropertiesForPrefix(String name, Current current) {
            return new TreeMap<String, String>(this._properties.getPropertiesForPrefix(name));
        }
    }

    static class ServiceInfo
    implements Cloneable {
        public String name;
        public Service service;
        public Communicator communicator = null;
        public int status;
        public String[] args;

        ServiceInfo() {
        }

        public Object clone() {
            Object o = null;
            try {
                o = super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return o;
        }
    }
}

