/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import omero.RBool;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.model.Correction;
import omero.model.Image;
import omero.model.ImagingEnvironment;
import omero.model.ImagingEnvironmentI;
import omero.model.Immersion;
import omero.model.Medium;
import omero.model.Objective;
import omero.model.ObjectiveI;
import omero.model.ObjectiveSettings;
import omero.model.ObjectiveSettingsI;
import omero.model.StageLabel;
import omero.model.StageLabelI;
import omero.rtypes;
import pojos.DataObject;

public class ImageAcquisitionData
extends DataObject {
    private StageLabel label;
    private ImagingEnvironment environment;
    private ObjectiveSettings objective;
    private boolean labelDirty;
    private boolean imagingEnvironmentDirty;
    private boolean objectiveSettingsDirty;
    private boolean objectiveDirty;
    private Medium medium;
    private Immersion immersion;
    private Correction correction;

    private Objective getObjective() {
        if (this.objective == null) {
            return null;
        }
        return this.objective.getObjective();
    }

    public ImageAcquisitionData(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(image);
        this.label = image.getStageLabel();
        this.environment = image.getImagingEnvironment();
        this.objective = image.getObjectiveSettings();
        this.medium = null;
        this.immersion = null;
        this.correction = null;
    }

    public String getLabelName() {
        if (this.label == null) {
            return "";
        }
        return this.label.getName().getValue();
    }

    public Object getPositionX() {
        if (this.label == null) {
            return null;
        }
        RDouble value = this.label.getPositionX();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Object getPositionY() {
        if (this.label == null) {
            return null;
        }
        RDouble value = this.label.getPositionY();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Object getPositionZ() {
        if (this.label == null) {
            return null;
        }
        RDouble value = this.label.getPositionZ();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Object getTemperature() {
        if (this.environment == null) {
            return null;
        }
        RDouble value = this.environment.getTemperature();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public double getAirPressure() {
        if (this.environment == null) {
            return -1.0;
        }
        RDouble value = this.environment.getAirPressure();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getHumidity() {
        if (this.environment == null) {
            return -1.0;
        }
        RDouble value = this.environment.getHumidity();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getCo2Percent() {
        if (this.environment == null) {
            return -1.0;
        }
        RDouble value = this.environment.getCo2percent();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getCorrectionCollar() {
        if (this.objective == null) {
            return -1.0;
        }
        RDouble value = this.objective.getCorrectionCollar();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getRefractiveIndex() {
        if (this.objective == null) {
            return -1.0;
        }
        RDouble value = this.objective.getRefractiveIndex();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public String getMedium() {
        if (this.medium != null) {
            return this.medium.getValue().getValue();
        }
        if (this.objective == null) {
            return "";
        }
        Medium value = this.objective.getMedium();
        if (value == null) {
            return "";
        }
        return value.getValue().getValue();
    }

    public double getCalibratedMagnification() {
        Objective obj = this.getObjective();
        if (obj == null) {
            return -1.0;
        }
        RDouble value = obj.getCalibratedMagnification();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public int getNominalMagnification() {
        Objective obj = this.getObjective();
        if (obj == null) {
            return -1;
        }
        RInt value = obj.getNominalMagnification();
        if (value == null) {
            return -1;
        }
        return value.getValue();
    }

    public double getLensNA() {
        Objective obj = this.getObjective();
        if (obj == null) {
            return -1.0;
        }
        RDouble value = obj.getLensNA();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public String getImmersion() {
        if (this.immersion != null) {
            return this.immersion.getValue().getValue();
        }
        Objective obj = this.getObjective();
        if (obj == null) {
            return "";
        }
        Immersion value = obj.getImmersion();
        if (value == null) {
            return "";
        }
        return value.getValue().getValue();
    }

    public String getCorrection() {
        if (this.correction != null) {
            return this.correction.getValue().getValue();
        }
        Objective obj = this.getObjective();
        if (obj == null) {
            return "";
        }
        Correction value = obj.getCorrection();
        if (value == null) {
            return "";
        }
        return value.getValue().getValue();
    }

    public double getWorkingDistance() {
        Objective obj = this.getObjective();
        if (obj == null) {
            return -1.0;
        }
        RDouble value = obj.getWorkingDistance();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public String getSerialNumber() {
        if (this.objective == null) {
            return "";
        }
        Objective obj = this.objective.getObjective();
        if (obj == null) {
            return "";
        }
        RString value = obj.getSerialNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getModel() {
        if (this.objective == null) {
            return "";
        }
        Objective obj = this.objective.getObjective();
        if (obj == null) {
            return "";
        }
        RString value = obj.getModel();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public Object hasIris() {
        if (this.objective == null) {
            return null;
        }
        Objective obj = this.objective.getObjective();
        if (obj == null) {
            return null;
        }
        RBool value = obj.getIris();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public void setIris(boolean iris) {
        this.objectiveDirty = true;
        Objective ob = this.objective.getObjective();
        if (ob == null) {
            ob = new ObjectiveI();
        }
        ob.setIris(rtypes.rbool(iris));
    }

    public String getManufacturer() {
        if (this.objective == null) {
            return "";
        }
        Objective obj = this.objective.getObjective();
        if (obj == null) {
            return "";
        }
        RString value = obj.getManufacturer();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public void setSerialNumber(String number) {
        this.objectiveDirty = true;
        Objective ob = this.objective.getObjective();
        if (ob == null) {
            ob = new ObjectiveI();
        }
        ob.setSerialNumber(rtypes.rstring(number));
    }

    public void setModel(String model) {
        this.objectiveDirty = true;
        Objective ob = this.objective.getObjective();
        if (ob == null) {
            ob = new ObjectiveI();
        }
        ob.setModel(rtypes.rstring(model));
    }

    public void setManufacturer(String manufacturer) {
        this.objectiveDirty = true;
        Objective ob = this.objective.getObjective();
        if (ob == null) {
            ob = new ObjectiveI();
        }
        ob.setManufacturer(rtypes.rstring(manufacturer));
    }

    public void setLabelName(String name) {
        this.labelDirty = true;
        if (this.label == null) {
            this.label = new StageLabelI();
        }
        this.label.setName(rtypes.rstring(name));
    }

    public void setPositionX(double value) {
        this.labelDirty = true;
        if (this.label == null) {
            this.label = new StageLabelI();
        }
        this.label.setPositionX(rtypes.rdouble(value));
    }

    public void setPositionY(double value) {
        this.labelDirty = true;
        if (this.label == null) {
            this.label = new StageLabelI();
        }
        this.label.setPositionY(rtypes.rdouble(value));
    }

    public void setPositionZ(double value) {
        this.labelDirty = true;
        if (this.label == null) {
            this.label = new StageLabelI();
        }
        this.label.setPositionZ(rtypes.rdouble(value));
    }

    public void setTemperature(double temperature) {
        this.imagingEnvironmentDirty = true;
        if (this.environment == null) {
            this.environment = new ImagingEnvironmentI();
        }
        this.environment.setTemperature(rtypes.rdouble(temperature));
    }

    public void setAirPressure(double pressure) {
        this.imagingEnvironmentDirty = true;
        if (this.environment == null) {
            this.environment = new ImagingEnvironmentI();
        }
        this.environment.setAirPressure(rtypes.rdouble(pressure));
    }

    public void setHumidity(double humidity) {
        if (humidity < 0.0 || humidity > 1.0) {
            throw new IllegalArgumentException("Humidity must be a value in [0, 1]");
        }
        this.imagingEnvironmentDirty = true;
        if (this.environment == null) {
            this.environment = new ImagingEnvironmentI();
        }
        this.environment.setHumidity(rtypes.rdouble(humidity));
    }

    public void setCo2Percent(double co2) {
        if (co2 < 0.0 || co2 > 1.0) {
            throw new IllegalArgumentException("Co2 must be a value in [0, 1]");
        }
        this.imagingEnvironmentDirty = true;
        if (this.environment == null) {
            this.environment = new ImagingEnvironmentI();
        }
        this.environment.setCo2percent(rtypes.rdouble(co2));
    }

    public void setCorrectionCollar(double correction) {
        this.objectiveSettingsDirty = true;
        if (this.objective == null) {
            this.objective = new ObjectiveSettingsI();
        }
        this.objective.setCorrectionCollar(rtypes.rdouble(correction));
    }

    public void setRefractiveIndex(double index) {
        this.objectiveSettingsDirty = true;
        if (this.objective == null) {
            this.objective = new ObjectiveSettingsI();
        }
        this.objective.setRefractiveIndex(rtypes.rdouble(index));
    }

    public void setMedium(Medium medium) {
        this.medium = medium;
        this.objectiveSettingsDirty = true;
    }

    public void setCalibratedMagnification(double factor) {
        this.objectiveDirty = true;
        Objective ob = this.objective.getObjective();
        if (ob == null) {
            ob = new ObjectiveI();
        }
        ob.setCalibratedMagnification(rtypes.rdouble(factor));
    }

    public void setNominalMagnification(int factor) {
        this.objectiveDirty = true;
        Objective ob = this.objective.getObjective();
        if (ob == null) {
            ob = new ObjectiveI();
        }
        ob.setNominalMagnification(rtypes.rint(factor));
    }

    public void setLensNA(double na) {
        this.objectiveDirty = true;
        Objective ob = this.objective.getObjective();
        if (ob == null) {
            ob = new ObjectiveI();
        }
        ob.setLensNA(rtypes.rdouble(na));
    }

    public void setWorkingDistance(double distance) {
        this.objectiveDirty = true;
        Objective ob = this.objective.getObjective();
        if (ob == null) {
            ob = new ObjectiveI();
        }
        ob.setWorkingDistance(rtypes.rdouble(distance));
    }

    public void setImmersion(Immersion immersion) {
        this.objectiveDirty = true;
        this.immersion = immersion;
    }

    public void setCorrection(Correction correction) {
        this.objectiveDirty = true;
        this.correction = correction;
    }

    public boolean isStageLabelDirty() {
        return this.labelDirty;
    }

    public boolean isImagingEnvironmentDirty() {
        return this.imagingEnvironmentDirty;
    }

    public boolean isObjectiveSettingsDirty() {
        return this.objectiveSettingsDirty;
    }

    public boolean isObjectiveDirty() {
        return this.objectiveDirty;
    }

    public long getStageLabelId() {
        if (this.label == null) {
            return -1L;
        }
        RLong id = this.label.getId();
        if (id == null) {
            return -1L;
        }
        return id.getValue();
    }

    public long getImagingEnvironmentId() {
        if (this.environment == null) {
            return -1L;
        }
        RLong id = this.environment.getId();
        if (id == null) {
            return -1L;
        }
        return id.getValue();
    }

    public long getObjectiveSettingsId() {
        if (this.objective == null) {
            return -1L;
        }
        RLong id = this.objective.getId();
        if (id == null) {
            return -1L;
        }
        return id.getValue();
    }

    public long getObjectiveId() {
        Objective ob = this.getObjective();
        if (ob == null) {
            return -1L;
        }
        RLong id = ob.getId();
        if (id == null) {
            return -1L;
        }
        return id.getValue();
    }

    public Medium getMediumAsEnum() {
        return this.medium;
    }

    public Immersion getImmersionAsEnum() {
        return this.immersion;
    }

    public Correction getCorrectionAsEnum() {
        return this.correction;
    }
}

