/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import omero.RBool;
import omero.RDouble;
import omero.RInt;
import omero.RString;
import omero.model.Arc;
import omero.model.ArcType;
import omero.model.Binning;
import omero.model.Detector;
import omero.model.DetectorI;
import omero.model.DetectorSettings;
import omero.model.DetectorSettingsI;
import omero.model.DetectorType;
import omero.model.Filament;
import omero.model.FilamentType;
import omero.model.Filter;
import omero.model.FilterSet;
import omero.model.Laser;
import omero.model.LaserMedium;
import omero.model.LaserType;
import omero.model.LightEmittingDiode;
import omero.model.LightSettings;
import omero.model.LightSettingsI;
import omero.model.LightSource;
import omero.model.LogicalChannel;
import omero.model.Pulse;
import omero.rtypes;
import pojos.DataObject;

public class ChannelAcquisitionData
extends DataObject {
    public static final String LASER = Laser.class.getName();
    public static final String FILAMENT = Filament.class.getName();
    public static final String ARC = Arc.class.getName();
    public static final String LIGHT_EMITTING_DIODE = LightEmittingDiode.class.getName();
    private DetectorSettings detectorSettings;
    private LightSettings lightSettings;
    private FilterSet filterSet;
    private Filter secondaryEmFilter;
    private Filter secondaryExFilter;
    private LightSource ligthSource;
    private boolean detectorDirty;
    private boolean detectorSettingsDirty;
    private boolean ligthSourceSettingsDirty;
    private boolean ligthSourceDirty;
    private Binning binning;
    private DetectorType detectorType;
    private String lightType;

    private LightSource getLightSource() {
        if (this.lightSettings == null) {
            return null;
        }
        if (this.ligthSource != null) {
            return this.ligthSource;
        }
        return this.lightSettings.getLightSource();
    }

    private Detector getDetector() {
        if (this.detectorSettings == null) {
            return null;
        }
        return this.detectorSettings.getDetector();
    }

    public ChannelAcquisitionData(LogicalChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(channel);
        this.detectorSettings = channel.getDetectorSettings();
        this.lightSettings = channel.getLightSourceSettings();
        this.filterSet = channel.getFilterSet();
        this.secondaryEmFilter = channel.getSecondaryEmissionFilter();
        this.secondaryExFilter = channel.getSecondaryExcitationFilter();
    }

    public double getDetectorSettingsOffset() {
        if (this.detectorSettings == null) {
            return -1.0;
        }
        RDouble value = this.detectorSettings.getOffsetValue();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getDetectorSettingsGain() {
        if (this.detectorSettings == null) {
            return -1.0;
        }
        RDouble value = this.detectorSettings.getGain();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getDetectorSettingsVoltage() {
        if (this.detectorSettings == null) {
            return -1.0;
        }
        RDouble value = this.detectorSettings.getVoltage();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getDetectorSettingsReadOutRate() {
        if (this.detectorSettings == null) {
            return -1.0;
        }
        RDouble value = this.detectorSettings.getReadOutRate();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public String getDetectorSettingsBinning() {
        if (this.binning != null) {
            return this.binning.getValue().getValue();
        }
        if (this.detectorSettings == null) {
            return "";
        }
        Binning value = this.detectorSettings.getBinning();
        if (value == null) {
            return "";
        }
        return value.getValue().getValue();
    }

    public double getDetectorVoltage() {
        Detector detector = this.getDetector();
        if (detector == null) {
            return -1.0;
        }
        RDouble value = detector.getVoltage();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getDetectorAmplificationGain() {
        Detector detector = this.getDetector();
        if (detector == null) {
            return -1.0;
        }
        RDouble value = detector.getAmplificationGain();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getDetectorGain() {
        Detector detector = this.getDetector();
        if (detector == null) {
            return -1.0;
        }
        RDouble value = detector.getGain();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getDetectorOffset() {
        Detector detector = this.getDetector();
        if (detector == null) {
            return -1.0;
        }
        RDouble value = detector.getOffsetValue();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getDetectorZoom() {
        Detector detector = this.getDetector();
        if (detector == null) {
            return -1.0;
        }
        RDouble value = detector.getZoom();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public String getDetectorType() {
        if (this.detectorType != null) {
            return this.detectorType.getValue().getValue();
        }
        Detector detector = this.getDetector();
        if (detector == null) {
            return "";
        }
        DetectorType type = detector.getType();
        if (type == null) {
            return "";
        }
        return type.getValue().getValue();
    }

    public String getDetectorManufacturer() {
        Detector detector = this.getDetector();
        if (detector == null) {
            return "";
        }
        RString value = detector.getManufacturer();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getDetectorModel() {
        Detector detector = this.getDetector();
        if (detector == null) {
            return "";
        }
        RString value = detector.getModel();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getDetectorSerialNumber() {
        Detector detector = this.getDetector();
        if (detector == null) {
            return "";
        }
        RString value = detector.getSerialNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public double getLigthSettingsAttenuation() {
        if (this.lightSettings == null) {
            return -1.0;
        }
        RDouble value = this.lightSettings.getAttenuation();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public int getLigthSettingsWavelength() {
        if (this.lightSettings == null) {
            return -1;
        }
        RInt value = this.lightSettings.getWavelength();
        if (value == null) {
            return -1;
        }
        return value.getValue();
    }

    public String getSecondaryExFilterManufacturer() {
        if (this.secondaryExFilter == null) {
            return "";
        }
        RString value = this.secondaryExFilter.getManufacturer();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getSecondaryExFilterModel() {
        if (this.secondaryExFilter == null) {
            return "";
        }
        RString value = this.secondaryExFilter.getModel();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getSecondaryExFilterLotNumber() {
        if (this.secondaryExFilter == null) {
            return "";
        }
        RString value = this.secondaryEmFilter.getLotNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getSecondaryExFilterType() {
        if (this.secondaryExFilter == null) {
            return "";
        }
        RString value = this.secondaryExFilter.getLotNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getSecondaryExFilterFilterWheel() {
        if (this.secondaryExFilter == null) {
            return "";
        }
        RString value = this.secondaryExFilter.getFilterWheel();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getSecondaryEmFilterManufacturer() {
        if (this.secondaryEmFilter == null) {
            return "";
        }
        RString value = this.secondaryEmFilter.getManufacturer();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getSecondaryEmFilterModel() {
        if (this.secondaryEmFilter == null) {
            return "";
        }
        RString value = this.secondaryEmFilter.getModel();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getSecondaryEmFilterLotNumber() {
        if (this.secondaryEmFilter == null) {
            return "";
        }
        RString value = this.secondaryEmFilter.getLotNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getSecondaryEmFilterType() {
        if (this.secondaryEmFilter == null) {
            return "";
        }
        RString value = this.secondaryEmFilter.getLotNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getSecondaryEmFilterFilterWheel() {
        if (this.secondaryEmFilter == null) {
            return "";
        }
        RString value = this.secondaryEmFilter.getFilterWheel();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getLightSourceManufacturer() {
        LightSource light = this.getLightSource();
        if (light == null) {
            return "";
        }
        RString value = light.getManufacturer();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getLightSourceModel() {
        LightSource light = this.getLightSource();
        if (light == null) {
            return "";
        }
        RString value = light.getModel();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getLightSourceSerialNumber() {
        LightSource light = this.getLightSource();
        if (light == null) {
            return "";
        }
        RString value = light.getSerialNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public double getLightSourcePower() {
        LightSource light = this.getLightSource();
        if (light == null) {
            return -1.0;
        }
        RDouble value = light.getPower();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public String getLightType() {
        LightSource light = this.getLightSource();
        if (light == null) {
            return "";
        }
        RString value = null;
        if (light instanceof Laser) {
            LaserType t = ((Laser)light).getType();
            value = t.getValue();
        } else if (light instanceof Filament) {
            FilamentType t = ((Filament)light).getType();
            value = t.getValue();
        } else if (light instanceof Arc) {
            ArcType t = ((Arc)light).getType();
            value = t.getValue();
        }
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getLaserMedium() {
        LightSource light = this.getLightSource();
        if (light == null || !(light instanceof Laser)) {
            return "";
        }
        Laser laser = (Laser)light;
        LaserMedium medium = laser.getLaserMedium();
        return medium.getValue().getValue();
    }

    public int getLaserWavelength() {
        if (!LASER.equals(this.getLightSourceKind())) {
            return -1;
        }
        Laser laser = (Laser)this.getLightSource();
        RInt value = laser.getWavelength();
        if (value == null) {
            return -1;
        }
        return value.getValue();
    }

    public Object getLaserTuneable() {
        LightSource light = this.getLightSource();
        if (light == null || !(light instanceof Laser)) {
            return null;
        }
        Laser laser = (Laser)light;
        RBool value = laser.getTuneable();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public String getLightSourceKind() {
        LightSource light = this.getLightSource();
        if (light == null) {
            return "";
        }
        if (light instanceof Laser) {
            return LASER;
        }
        if (light instanceof Filament) {
            return FILAMENT;
        }
        if (light instanceof Arc) {
            return ARC;
        }
        if (light instanceof LightEmittingDiode) {
            return LIGHT_EMITTING_DIODE;
        }
        return "";
    }

    public boolean hasDectector() {
        return this.getDetector() != null;
    }

    public boolean hasLightSource() {
        return this.getLightSource() != null;
    }

    public boolean hasPump() {
        if (!LASER.equals(this.getLightSourceKind())) {
            return false;
        }
        Laser laser = (Laser)this.getLightSource();
        return laser.getPump() != null;
    }

    public int getLaserFrequencyMultiplication() {
        if (!LASER.equals(this.getLightSourceKind())) {
            return -1;
        }
        Laser laser = (Laser)this.getLightSource();
        RInt value = laser.getFrequencyMultiplication();
        if (value == null) {
            return -1;
        }
        return value.getValue();
    }

    public String getLaserPulse() {
        if (!LASER.equals(this.getLightSourceKind())) {
            return null;
        }
        Laser laser = (Laser)this.getLightSource();
        Pulse value = laser.getPulse();
        if (value == null) {
            return null;
        }
        return value.getValue().getValue();
    }

    public Object getLaserPockelCell() {
        if (!LASER.equals(this.getLightSourceKind())) {
            return null;
        }
        Laser laser = (Laser)this.getLightSource();
        RBool value = laser.getPockelCell();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public double getLaserRepetitionRate() {
        if (!LASER.equals(this.getLightSourceKind())) {
            return -1.0;
        }
        Laser laser = (Laser)this.getLightSource();
        RDouble value = laser.getRepetitionRate();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public long getLightSourceId() {
        LightSource source = this.getLightSource();
        if (source == null) {
            return -1L;
        }
        return source.getId().getValue();
    }

    public void setLightSourceSerialNumber(String number) {
        this.ligthSourceDirty = true;
        LightSource light = this.getLightSource();
        if (light == null) {
            return;
        }
        light.setSerialNumber(rtypes.rstring(number));
    }

    public void setLightSourceModel(String model) {
        this.ligthSourceDirty = true;
        LightSource light = this.getLightSource();
        if (light == null) {
            return;
        }
        light.setModel(rtypes.rstring(model));
    }

    public void setLightSourceManufacturer(String manufacturer) {
        this.ligthSourceDirty = true;
        LightSource light = this.getLightSource();
        if (light == null) {
            return;
        }
        light.setManufacturer(rtypes.rstring(manufacturer));
    }

    public void setLightSourcePower(double value) {
        this.ligthSourceDirty = true;
        LightSource light = this.getLightSource();
        if (light == null) {
            return;
        }
        light.setPower(rtypes.rdouble(value));
    }

    public void setLigthSettingsAttenuation(double value) {
        this.ligthSourceSettingsDirty = true;
        if (this.lightSettings == null) {
            this.lightSettings = new LightSettingsI();
        }
        this.lightSettings.setAttenuation(rtypes.rdouble(value));
    }

    public void setLigthSettingsWavelength(int value) {
        this.ligthSourceSettingsDirty = true;
        if (this.lightSettings == null) {
            this.lightSettings = new LightSettingsI();
        }
        this.lightSettings.setWavelength(rtypes.rint(value));
    }

    public void setDetectorSerialNumber(String number) {
        this.detectorDirty = true;
        Detector d = this.getDetector();
        if (d == null) {
            d = new DetectorI();
        }
        d.setSerialNumber(rtypes.rstring(number));
    }

    public void setDetectorModel(String model) {
        this.detectorDirty = true;
        Detector d = this.getDetector();
        if (d == null) {
            d = new DetectorI();
        }
        d.setModel(rtypes.rstring(model));
    }

    public void setDetectorManufacturer(String manufacturer) {
        this.detectorDirty = true;
        Detector d = this.getDetector();
        if (d == null) {
            d = new DetectorI();
        }
        d.setManufacturer(rtypes.rstring(manufacturer));
    }

    public void setDetectorAmplificationGain(double value) {
        this.detectorDirty = true;
        Detector d = this.getDetector();
        if (d == null) {
            d = new DetectorI();
        }
        d.setAmplificationGain(rtypes.rdouble(value));
    }

    public void setDetectorGain(double value) {
        this.detectorDirty = true;
        Detector d = this.getDetector();
        if (d == null) {
            d = new DetectorI();
        }
        d.setGain(rtypes.rdouble(value));
    }

    public void setDetectorOffset(double value) {
        this.detectorDirty = true;
        Detector d = this.getDetector();
        if (d == null) {
            d = new DetectorI();
        }
        d.setOffsetValue(rtypes.rdouble(value));
    }

    public void setDetectorVoltage(double value) {
        this.detectorDirty = true;
        Detector d = this.getDetector();
        if (d == null) {
            d = new DetectorI();
        }
        d.setVoltage(rtypes.rdouble(value));
    }

    public void setDetectorZoom(double value) {
        this.detectorDirty = true;
        Detector d = this.getDetector();
        if (d == null) {
            d = new DetectorI();
        }
        d.setZoom(rtypes.rdouble(value));
    }

    public void setDetectorType(DetectorType detectorType) {
        this.detectorDirty = true;
        this.detectorType = detectorType;
    }

    public void setDetectorSettingOffset(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setOffsetValue(rtypes.rdouble(value));
    }

    public void setDetectorSettingsGain(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setGain(rtypes.rdouble(value));
    }

    public void setDetectorSettingsReadOutRate(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setReadOutRate(rtypes.rdouble(value));
    }

    public void setDetectorSettingsVoltage(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setVoltage(rtypes.rdouble(value));
    }

    public void setDetectorSettingBinning(Binning binning) {
        this.binning = binning;
    }

    public Binning getDetectorBinningAsEnum() {
        return this.binning;
    }

    public DetectorType getDetectorTypeAsEnum() {
        return this.detectorType;
    }

    public boolean isDetectorDirty() {
        return this.detectorDirty;
    }

    public boolean isDetectorSettingsDirty() {
        return this.detectorSettingsDirty;
    }

    public boolean isLightSourceSettingsDirty() {
        return this.ligthSourceSettingsDirty;
    }

    public boolean isLightSourceDirty() {
        return this.ligthSourceDirty;
    }
}

