/*
 * Decompiled with CFR 0.152.
 */
package omerojava.util;

import omerojava.util.BytesConverter;
import omerojava.util.ReadOnlyByteArray;

public class Plane2D {
    private int bytesPerPixel;
    private int sizeX;
    private int sizeY;
    private ReadOnlyByteArray data;
    private BytesConverter strategy;

    private int calculateOffset(int x, int y) {
        return this.bytesPerPixel * (this.sizeX * y + x);
    }

    private double[][] mappedDataAsDouble(int sizeY, boolean transpose) {
        double[][] mappedData = transpose ? new double[sizeY][this.sizeX] : new double[this.sizeX][sizeY];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                int offset = this.calculateOffset(x, y);
                if (transpose) {
                    mappedData[y][x] = this.strategy.pack(this.data, offset, this.bytesPerPixel);
                    continue;
                }
                mappedData[x][y] = this.strategy.pack(this.data, offset, this.bytesPerPixel);
            }
        }
        return mappedData;
    }

    private long[][] mappedDataAsLong(int sizeY, boolean transpose) {
        long[][] mappedData = transpose ? new long[sizeY][this.sizeX] : new long[this.sizeX][sizeY];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                int offset = this.calculateOffset(x, y);
                if (transpose) {
                    mappedData[y][x] = (long)this.strategy.pack(this.data, offset, this.bytesPerPixel);
                    continue;
                }
                mappedData[x][y] = (long)this.strategy.pack(this.data, offset, this.bytesPerPixel);
            }
        }
        return mappedData;
    }

    private int[][] mappedDataAsInt(int sizeY, boolean transpose) {
        int[][] mappedData = transpose ? new int[sizeY][this.sizeX] : new int[this.sizeX][sizeY];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                int offset = this.calculateOffset(x, y);
                if (transpose) {
                    mappedData[y][x] = (int)this.strategy.pack(this.data, offset, this.bytesPerPixel);
                    continue;
                }
                mappedData[x][y] = (int)this.strategy.pack(this.data, offset, this.bytesPerPixel);
            }
        }
        return mappedData;
    }

    private short[][] mappedDataAsShort(int sizeY, boolean transpose) {
        short[][] mappedData = transpose ? new short[sizeY][this.sizeX] : new short[this.sizeX][sizeY];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                int offset = this.calculateOffset(x, y);
                if (transpose) {
                    mappedData[y][x] = (short)this.strategy.pack(this.data, offset, this.bytesPerPixel);
                    continue;
                }
                mappedData[x][y] = (short)this.strategy.pack(this.data, offset, this.bytesPerPixel);
            }
        }
        return mappedData;
    }

    private byte[][] mappedDataAsByte(int sizeY, boolean transpose) {
        byte[][] mappedData = transpose ? new byte[sizeY][this.sizeX] : new byte[this.sizeX][sizeY];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                int offset = this.calculateOffset(x, y);
                if (transpose) {
                    mappedData[y][x] = (byte)this.strategy.pack(this.data, offset, this.bytesPerPixel);
                    continue;
                }
                mappedData[x][y] = (byte)this.strategy.pack(this.data, offset, this.bytesPerPixel);
            }
        }
        return mappedData;
    }

    public Plane2D(ReadOnlyByteArray data, int sizeX, int sizeY, int bytesPerPixel, BytesConverter strategy) {
        this.bytesPerPixel = bytesPerPixel;
        this.data = data;
        this.strategy = strategy;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    public double[][] getPixelsArrayAsDouble(boolean transpose) {
        return this.mappedDataAsDouble(this.sizeY, transpose);
    }

    public long[][] getPixelsArrayAsLong(boolean transpose) {
        return this.mappedDataAsLong(this.sizeY, transpose);
    }

    public int[][] getPixelsArrayAsInt(boolean transpose) {
        return this.mappedDataAsInt(this.sizeY, transpose);
    }

    public short[][] getPixelsArrayAsShort(boolean transpose) {
        return this.mappedDataAsShort(this.sizeY, transpose);
    }

    public byte[][] getPixelsArrayAsByte(boolean transpose) {
        return this.mappedDataAsByte(this.sizeY, transpose);
    }
}

