/*
 * Decompiled with CFR 0.152.
 */
package ome.model.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.persistence.Column;
import ome.conditions.ApiUsageException;

public class Permissions
implements Serializable {
    private static final long serialVersionUID = 7089149309186580238L;
    private long perm1 = -1L;
    public static final Permissions EMPTY = new ImmutablePermissions(new Permissions().revoke(Role.USER, Right.READ, Right.WRITE).revoke(Role.GROUP, Right.READ, Right.WRITE).revoke(Role.WORLD, Right.READ, Right.WRITE));
    public static final Permissions USER_IMMUTABLE = new ImmutablePermissions(new Permissions(EMPTY).grant(Role.USER, Right.READ));
    public static final Permissions USER_PRIVATE = new ImmutablePermissions(new Permissions(EMPTY).grant(Role.USER, Right.READ, Right.WRITE));
    public static final Permissions GROUP_READABLE = new ImmutablePermissions(new Permissions(USER_PRIVATE).grant(Role.GROUP, Right.READ));
    public static final Permissions GROUP_PRIVATE = new ImmutablePermissions(new Permissions(GROUP_READABLE).grant(Role.GROUP, Right.WRITE));
    public static final Permissions GROUP_WRITEABLE = new ImmutablePermissions(new Permissions(GROUP_PRIVATE).grant(Role.WORLD, Right.READ));
    public static final Permissions WORLD_WRITEABLE = new ImmutablePermissions(new Permissions(GROUP_WRITEABLE).grant(Role.WORLD, Right.WRITE));
    public static final Permissions USER_WRITEABLE = new ImmutablePermissions(new Permissions(GROUP_READABLE).grant(Role.WORLD, Right.READ));
    public static final Permissions WORLD_IMMUTABLE = new ImmutablePermissions(new Permissions(USER_WRITEABLE).revoke(Role.USER, Right.WRITE));
    public static final Permissions GROUP_IMMUTABLE = new ImmutablePermissions(new Permissions(WORLD_IMMUTABLE).revoke(Role.WORLD, Right.READ));
    public static final Permissions DEFAULT = USER_PRIVATE;
    public static final Permissions READ_ONLY = WORLD_IMMUTABLE;
    public static final Permissions PUBLIC = WORLD_WRITEABLE;

    public Permissions() {
    }

    public Permissions(Permissions p) {
        if (p == null) {
            throw new IllegalArgumentException("Permissions argument cannot be null.");
        }
        this.revokeAll(p);
    }

    public boolean isGranted(Role role, Right right) {
        return (this.perm1 & (long)(right.mask() << role.shift())) == (long)(right.mask() << role.shift());
    }

    public boolean isSet(Flag flag) {
        return (this.perm1 & (long)flag.bit()) != (long)flag.bit();
    }

    public static int bit(Role role, Right right) {
        return right.mask() << role.shift();
    }

    public static Permissions parseString(String rwrwrw) {
        Permissions p = new Permissions(EMPTY);
        String regex = "([Rr_][Ww_]){3}";
        if (rwrwrw == null || !rwrwrw.matches(regex)) {
            throw new ApiUsageException("Permissions are of the form: " + regex);
        }
        char c = rwrwrw.charAt(0);
        if (c == 'r' || c == 'R') {
            p.grant(Role.USER, Right.READ);
        }
        if ((c = rwrwrw.charAt(1)) == 'w' || c == 'W') {
            p.grant(Role.USER, Right.WRITE);
        }
        if ((c = rwrwrw.charAt(2)) == 'r' || c == 'R') {
            p.grant(Role.GROUP, Right.READ);
        }
        if ((c = rwrwrw.charAt(3)) == 'w' || c == 'W') {
            p.grant(Role.GROUP, Right.WRITE);
        }
        if ((c = rwrwrw.charAt(4)) == 'r' || c == 'R') {
            p.grant(Role.WORLD, Right.READ);
        }
        if ((c = rwrwrw.charAt(5)) == 'w' || c == 'W') {
            p.grant(Role.WORLD, Right.WRITE);
        }
        return p;
    }

    public Permissions grant(Role role, Right ... rights) {
        if (rights != null && rights.length > 0) {
            for (Right right : rights) {
                this.perm1 |= Permissions.singleBitOn(role, right);
            }
        }
        return this;
    }

    public Permissions revoke(Role role, Right ... rights) {
        if (rights != null && rights.length > 0) {
            for (Right right : rights) {
                this.perm1 &= Permissions.singleBitOut(role, right);
            }
        }
        return this;
    }

    public Permissions grantAll(Permissions mask) {
        if (mask == null) {
            return this;
        }
        long maskPerm1 = mask.getPerm1();
        this.perm1 |= maskPerm1;
        return this;
    }

    public Permissions revokeAll(Permissions mask) {
        if (mask == null) {
            return this;
        }
        long maskPerm1 = mask.getPerm1();
        this.perm1 &= maskPerm1;
        return this;
    }

    public Permissions set(Flag flag) {
        if (flag == null) {
            return this;
        }
        this.perm1 &= 0xFFFFFFFFFFFFFFFFL ^ (long)flag.bit();
        return this;
    }

    public Permissions unSet(Flag flag) {
        if (flag == null) {
            return this;
        }
        this.perm1 |= 0L ^ (long)flag.bit();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append(this.isSet(Flag.LOCKED) ? "L" : "");
        sb.append(this.isGranted(Role.USER, Right.READ) ? "r" : "-");
        sb.append(this.isGranted(Role.USER, Right.WRITE) ? "w" : "-");
        sb.append(this.isGranted(Role.GROUP, Right.READ) ? "r" : "-");
        sb.append(this.isGranted(Role.GROUP, Right.WRITE) ? "w" : "-");
        sb.append(this.isGranted(Role.WORLD, Right.READ) ? "r" : "-");
        sb.append(this.isGranted(Role.WORLD, Right.WRITE) ? "w" : "-");
        return sb.toString();
    }

    public boolean sameRights(Permissions p) {
        if (p == this) {
            return true;
        }
        for (Role ro : Role.values()) {
            for (Right rt : Right.values()) {
                if (this.isGranted(ro, rt) == p.isGranted(ro, rt)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean identical(Permissions p) {
        if (p == this) {
            return true;
        }
        return p.perm1 == this.perm1;
    }

    @Column(name="permissions", nullable=false)
    protected long getPerm1() {
        return this.perm1;
    }

    protected void setPerm1(long value) {
        this.perm1 = value;
    }

    protected static final long singleBitOut(Role role, Right right) {
        return 0xFFFFFFFFFFFFFFFFL ^ (long)(right.mask() << role.shift());
    }

    protected static final long singleBitOn(Role role, Right right) {
        return 0L | (long)(right.mask() << role.shift());
    }

    private static class ImmutablePermissions
    extends Permissions
    implements Serializable {
        private static final long serialVersionUID = -4407900270934589522L;
        private Permissions delegate;

        public static Permissions immutable(Permissions p) {
            return new ImmutablePermissions(p);
        }

        ImmutablePermissions(Permissions p) {
            if (p == null) {
                throw new IllegalArgumentException("Permissions may not be null");
            }
            this.delegate = new Permissions(p);
        }

        public Permissions grant(Role role, Right ... rights) {
            throw new UnsupportedOperationException();
        }

        public Permissions revoke(Role role, Right ... rights) {
            throw new UnsupportedOperationException();
        }

        public Permissions grantAll(Permissions mask) {
            throw new UnsupportedOperationException();
        }

        public Permissions revokeAll(Permissions mask) {
            throw new UnsupportedOperationException();
        }

        public Permissions set(Flag flag) {
            return this.delegate.set(flag);
        }

        public Permissions unSet(Flag flag) {
            return this.delegate.unSet(flag);
        }

        public boolean isGranted(Role role, Right right) {
            return this.delegate.isGranted(role, right);
        }

        protected long getPerm1() {
            return this.delegate.getPerm1();
        }

        protected void setPerm1(long value) {
            this.delegate.setPerm1(value);
        }

        public boolean isSet(Flag flag) {
            return this.delegate.isSet(flag);
        }

        public boolean identical(Permissions p) {
            return this.delegate.identical(p);
        }

        public boolean sameRights(Permissions p) {
            return this.delegate.sameRights(p);
        }

        public String toString() {
            return this.delegate.toString();
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            Permissions p = (Permissions)s.readObject();
            if (p == null) {
                throw new IllegalArgumentException("Permissions may not be null");
            }
            this.delegate = new Permissions(p);
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.writeObject(this.delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        LOCKED(262144),
        SOFT(131072);

        private final int bit;

        private Flag(int bit) {
            this.bit = bit;
        }

        int bit() {
            return this.bit;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Right {
        WRITE(2),
        READ(4);

        private final int mask;

        private Right(int mask) {
            this.mask = mask;
        }

        int mask() {
            return this.mask;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Role {
        USER(8),
        GROUP(4),
        WORLD(0);

        private final int shift;

        private Role(int shift) {
            this.shift = shift;
        }

        int shift() {
            return this.shift;
        }
    }
}

