/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.LocalException;
import Ice.Logger;
import Ice.PluginInitializationException;
import IceInternal.Connector;
import IceInternal.Network;
import IceInternal.Transceiver;
import IceSSL.Instance;
import IceSSL.TransceiverI;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;

final class ConnectorI
implements Connector,
Comparable {
    private Instance _instance;
    private Logger _logger;
    private String _host;
    private InetSocketAddress _addr;
    private int _timeout;
    private String _connectionId;
    private int _hashCode;

    public Transceiver connect() {
        if (!this._instance.initialized()) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: plugin is not initialized";
            throw ex;
        }
        if (this._instance.networkTraceLevel() >= 2) {
            String s = "trying to establish ssl connection to " + this.toString();
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
        try {
            SocketChannel fd = Network.createTcpSocket();
            Network.setBlock(fd, false);
            Network.setTcpBufSize(fd, this._instance.communicator().getProperties(), this._logger);
            boolean connected = Network.doConnect(fd, this._addr);
            try {
                SSLEngine engine = this._instance.createSSLEngine(false);
                return new TransceiverI(this._instance, engine, fd, this._host, connected, false, "");
            }
            catch (RuntimeException ex) {
                Network.closeSocketNoThrow(fd);
                throw ex;
            }
        }
        catch (LocalException ex) {
            if (this._instance.networkTraceLevel() >= 2) {
                String s = "failed to establish ssl connection to " + this.toString() + "\n" + ex;
                this._logger.trace(this._instance.networkTraceCategory(), s);
            }
            throw ex;
        }
    }

    public short type() {
        return 2;
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    public int hashCode() {
        return this._hashCode;
    }

    ConnectorI(Instance instance, InetSocketAddress addr, int timeout, String connectionId) {
        this._instance = instance;
        this._logger = instance.communicator().getLogger();
        this._host = addr.getHostName();
        this._addr = addr;
        this._timeout = timeout;
        this._connectionId = connectionId;
        this._hashCode = this._addr.getAddress().getHostAddress().hashCode();
        this._hashCode = 5 * this._hashCode + this._addr.getPort();
        this._hashCode = 5 * this._hashCode + this._timeout;
        this._hashCode = 5 * this._hashCode + this._connectionId.hashCode();
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        ConnectorI p;
        block10: {
            p = null;
            try {
                p = (ConnectorI)obj;
            }
            catch (ClassCastException ex) {
                try {
                    Connector c = (Connector)obj;
                    return this.type() < c.type() ? -1 : 1;
                }
                catch (ClassCastException ee) {
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError();
                }
            }
        }
        if (this == p) {
            return 0;
        }
        if (this._timeout < p._timeout) {
            return -1;
        }
        if (p._timeout < this._timeout) {
            return 1;
        }
        if (!this._connectionId.equals(p._connectionId)) {
            return this._connectionId.compareTo(p._connectionId);
        }
        if (this._timeout < p._timeout) {
            return -1;
        }
        if (p._timeout < this._timeout) {
            return 1;
        }
        return Network.compareAddress(this._addr, p._addr);
    }

    protected synchronized void finalize() throws Throwable {
        super.finalize();
    }
}

