/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AMI_Locator_findAdapterById;
import Ice.AMI_Locator_findObjectById;
import Ice.AdapterNotFoundException;
import Ice.BooleanHolder;
import Ice.CollocationOptimizationException;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorRegistryPrx;
import Ice.LocatorRegistryPrxHelper;
import Ice.NotRegisteredException;
import Ice.ObjectNotFoundException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.UserException;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.LocatorTable;
import IceInternal.Reference;

public final class LocatorInfo {
    private final LocatorPrx _locator;
    private LocatorRegistryPrx _locatorRegistry;
    private final LocatorTable _table;

    LocatorInfo(LocatorPrx locator, LocatorTable table) {
        this._locator = locator;
        this._table = table;
    }

    public synchronized void destroy() {
        this._locatorRegistry = null;
        this._table.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocatorInfo) {
            return this._locator.equals(((LocatorInfo)obj)._locator);
        }
        return false;
    }

    public LocatorPrx getLocator() {
        return this._locator;
    }

    public synchronized LocatorRegistryPrx getLocatorRegistry() {
        if (this._locatorRegistry == null) {
            this._locatorRegistry = this._locator.getRegistry();
            this._locatorRegistry = LocatorRegistryPrxHelper.uncheckedCast(this._locatorRegistry.ice_locator(null));
        }
        return this._locatorRegistry;
    }

    public EndpointI[] getEndpoints(Reference ref, int ttl, BooleanHolder cached) {
        assert (ref.isIndirect());
        EndpointI[] endpoints = null;
        ObjectPrx object = null;
        cached.value = true;
        String adapterId = ref.getAdapterId();
        Identity identity = ref.getIdentity();
        try {
            if (adapterId.length() > 0) {
                endpoints = this._table.getAdapterEndpoints(adapterId, ttl);
                if (endpoints == null) {
                    cached.value = false;
                    if (ref.getInstance().traceLevels().location >= 1) {
                        StringBuffer s = new StringBuffer();
                        s.append("searching for adapter by id\n");
                        s.append("adapter = " + adapterId);
                        ref.getInstance().initializationData().logger.trace(ref.getInstance().traceLevels().locationCat, s.toString());
                    }
                    if ((object = this._locator.findAdapterById(adapterId)) != null && (endpoints = ((ObjectPrxHelperBase)object).__reference().getEndpoints()).length > 0) {
                        this._table.addAdapterEndpoints(adapterId, endpoints);
                    }
                }
            } else {
                boolean objectCached = true;
                object = this._table.getProxy(identity, ttl);
                if (object == null) {
                    objectCached = false;
                    if (ref.getInstance().traceLevels().location >= 1) {
                        StringBuffer s = new StringBuffer();
                        s.append("searching for object by id\n");
                        s.append("object = " + ref.getInstance().identityToString(identity));
                        ref.getInstance().initializationData().logger.trace(ref.getInstance().traceLevels().locationCat, s.toString());
                    }
                    object = this._locator.findObjectById(identity);
                }
                boolean endpointsCached = true;
                if (object != null) {
                    Reference r = ((ObjectPrxHelperBase)object).__reference();
                    if (!r.isIndirect()) {
                        endpointsCached = false;
                        endpoints = r.getEndpoints();
                    } else if (!r.isWellKnown()) {
                        BooleanHolder c = new BooleanHolder();
                        endpoints = this.getEndpoints(r, ttl, c);
                        endpointsCached = c.value;
                    }
                }
                if (!objectCached && endpoints != null && endpoints.length > 0) {
                    this._table.addProxy(identity, object);
                }
                cached.value = objectCached || endpointsCached;
            }
        }
        catch (Exception ex) {
            this.getEndpointsException(ref, ex);
        }
        if (ref.getInstance().traceLevels().location >= 1) {
            this.getEndpointsTrace(ref, endpoints, cached.value);
        }
        return endpoints == null ? new EndpointI[]{} : endpoints;
    }

    public void getEndpoints(final Reference ref, final int ttl, final GetEndpointsCallback callback) {
        final String adapterId = ref.getAdapterId();
        Identity identity = ref.getIdentity();
        final Instance instance = ref.getInstance();
        if (adapterId.length() > 0) {
            EndpointI[] endpoints = this._table.getAdapterEndpoints(adapterId, ttl);
            if (endpoints == null) {
                if (instance.traceLevels().location >= 1) {
                    StringBuffer s = new StringBuffer();
                    s.append("searching for adapter by id\n");
                    s.append("adapter = " + adapterId);
                    instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
                }
                this._locator.findAdapterById_async(new AMI_Locator_findAdapterById(){

                    public void ice_response(ObjectPrx object) {
                        EndpointI[] endpoints = null;
                        if (object != null && (endpoints = ((ObjectPrxHelperBase)object).__reference().getEndpoints()).length > 0) {
                            LocatorInfo.this._table.addAdapterEndpoints(adapterId, endpoints);
                        }
                        if (instance.traceLevels().location >= 1) {
                            LocatorInfo.this.getEndpointsTrace(ref, endpoints, false);
                        }
                        if (endpoints == null) {
                            callback.setEndpoints(new EndpointI[0], false);
                        } else {
                            callback.setEndpoints(endpoints, false);
                        }
                    }

                    public void ice_exception(UserException ex) {
                        LocatorInfo.this.getEndpointsException(ref, ex, callback);
                    }

                    public void ice_exception(LocalException ex) {
                        if (ex instanceof CollocationOptimizationException) {
                            try {
                                BooleanHolder cached = new BooleanHolder();
                                callback.setEndpoints(LocatorInfo.this.getEndpoints(ref, ttl, cached), cached.value);
                            }
                            catch (LocalException e) {
                                callback.setException(e);
                            }
                        } else {
                            LocatorInfo.this.getEndpointsException(ref, ex, callback);
                        }
                    }
                }, adapterId);
                return;
            }
            if (instance.traceLevels().location >= 1) {
                this.getEndpointsTrace(ref, endpoints, true);
            }
            callback.setEndpoints(endpoints, true);
            return;
        }
        ObjectPrx object = this._table.getProxy(identity, ttl);
        if (object == null) {
            if (instance.traceLevels().location >= 1) {
                StringBuffer s = new StringBuffer();
                s.append("searching for object by id\n");
                s.append("object = " + instance.identityToString(identity));
                instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
            }
            this._locator.findObjectById_async(new AMI_Locator_findObjectById(){

                public void ice_response(ObjectPrx object) {
                    LocatorInfo.this.getWellKnownObjectEndpoints(ref, object, ttl, false, callback);
                }

                public void ice_exception(UserException ex) {
                    LocatorInfo.this.getEndpointsException(ref, ex, callback);
                }

                public void ice_exception(LocalException ex) {
                    if (ex instanceof CollocationOptimizationException) {
                        try {
                            BooleanHolder cached = new BooleanHolder();
                            callback.setEndpoints(LocatorInfo.this.getEndpoints(ref, ttl, cached), cached.value);
                        }
                        catch (LocalException e) {
                            callback.setException(e);
                        }
                    } else {
                        LocatorInfo.this.getEndpointsException(ref, ex, callback);
                    }
                }
            }, identity);
            return;
        }
        this.getWellKnownObjectEndpoints(ref, object, ttl, true, callback);
    }

    public void clearObjectCache(Reference ref) {
        ObjectPrx object;
        assert (ref.isIndirect());
        if (ref.isWellKnown() && (object = this._table.removeProxy(ref.getIdentity())) != null) {
            Reference r = ((ObjectPrxHelperBase)object).__reference();
            if (!r.isIndirect()) {
                if (ref.getInstance().traceLevels().location >= 2) {
                    this.trace("removed endpoints from locator table", ref, r.getEndpoints());
                }
            } else if (!r.isWellKnown()) {
                this.clearCache(r);
            }
        }
    }

    public void clearCache(Reference ref) {
        assert (ref.isIndirect());
        if (!ref.isWellKnown()) {
            EndpointI[] endpoints = this._table.removeAdapterEndpoints(ref.getAdapterId());
            if (endpoints != null && ref.getInstance().traceLevels().location >= 2) {
                this.trace("removed endpoints from locator table\n", ref, endpoints);
            }
        } else {
            ObjectPrx object = this._table.removeProxy(ref.getIdentity());
            if (object != null) {
                Reference r = ((ObjectPrxHelperBase)object).__reference();
                if (!r.isIndirect()) {
                    if (ref.getInstance().traceLevels().location >= 2) {
                        this.trace("removed endpoints from locator table", ref, r.getEndpoints());
                    }
                } else if (!r.isWellKnown()) {
                    this.clearCache(r);
                }
            }
        }
    }

    private void trace(String msg, Reference ref, EndpointI[] endpoints) {
        assert (ref.isIndirect());
        StringBuffer s = new StringBuffer();
        s.append(msg + "\n");
        if (!ref.isWellKnown()) {
            s.append("adapter = " + ref.getAdapterId() + "\n");
        } else {
            s.append("object = " + ref.getInstance().identityToString(ref.getIdentity()) + "\n");
        }
        s.append("endpoints = ");
        int sz = endpoints.length;
        for (int i = 0; i < sz; ++i) {
            s.append(endpoints[i].toString());
            if (i + 1 >= sz) continue;
            s.append(":");
        }
        ref.getInstance().initializationData().logger.trace(ref.getInstance().traceLevels().locationCat, s.toString());
    }

    private void getEndpointsException(Reference ref, Exception exc) {
        assert (ref.isIndirect());
        try {
            throw exc;
        }
        catch (AdapterNotFoundException ex) {
            Instance instance = ref.getInstance();
            if (instance.traceLevels().location >= 1) {
                StringBuffer s = new StringBuffer();
                s.append("adapter not found\n");
                s.append("adapter = " + ref.getAdapterId());
                instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
            }
            NotRegisteredException e = new NotRegisteredException();
            e.kindOfObject = "object adapter";
            e.id = ref.getAdapterId();
            throw e;
        }
        catch (ObjectNotFoundException ex) {
            Instance instance = ref.getInstance();
            if (instance.traceLevels().location >= 1) {
                StringBuffer s = new StringBuffer();
                s.append("object not found\n");
                s.append("object = " + instance.identityToString(ref.getIdentity()));
                instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
            }
            NotRegisteredException e = new NotRegisteredException();
            e.kindOfObject = "object";
            e.id = instance.identityToString(ref.getIdentity());
            throw e;
        }
        catch (NotRegisteredException ex) {
            throw ex;
        }
        catch (LocalException ex) {
            Instance instance = ref.getInstance();
            if (instance.traceLevels().location >= 1) {
                StringBuffer s = new StringBuffer();
                s.append("couldn't contact the locator to retrieve adapter endpoints\n");
                if (ref.getAdapterId().length() > 0) {
                    s.append("adapter = " + ref.getAdapterId() + "\n");
                } else {
                    s.append("object = " + instance.identityToString(ref.getIdentity()) + "\n");
                }
                s.append("reason = " + ex);
                instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
            }
            throw ex;
        }
        catch (Exception ex) {
            assert (false);
            return;
        }
    }

    private void getEndpointsException(Reference ref, Exception exc, GetEndpointsCallback callback) {
        block3: {
            try {
                this.getEndpointsException(ref, exc);
            }
            catch (LocalException ex) {
                callback.setException(ex);
            }
            catch (Exception ex) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    private void getWellKnownObjectEndpoints(final Reference ref, final ObjectPrx object, int ttl, final boolean objectCached, final GetEndpointsCallback callback) {
        EndpointI[] endpoints = null;
        if (object != null) {
            Reference r = ((ObjectPrxHelperBase)object).__reference();
            if (!r.isIndirect()) {
                endpoints = r.getEndpoints();
            } else if (!r.isWellKnown()) {
                this.getEndpoints(r, ttl, new GetEndpointsCallback(){

                    public void setEndpoints(EndpointI[] endpoints, boolean endpointsCached) {
                        if (!objectCached && endpoints != null && endpoints.length > 0) {
                            LocatorInfo.this._table.addProxy(ref.getIdentity(), object);
                        }
                        if (ref.getInstance().traceLevels().location >= 1) {
                            LocatorInfo.this.getEndpointsTrace(ref, endpoints, objectCached || endpointsCached);
                        }
                        callback.setEndpoints(endpoints, objectCached || endpointsCached);
                    }

                    public void setException(LocalException ex) {
                        callback.setException(ex);
                    }
                });
                return;
            }
        }
        if (!objectCached && endpoints != null && endpoints.length > 0) {
            this._table.addProxy(ref.getIdentity(), object);
        }
        if (ref.getInstance().traceLevels().location >= 1) {
            this.getEndpointsTrace(ref, endpoints, objectCached);
        }
        if (endpoints == null) {
            callback.setEndpoints(new EndpointI[0], false);
        } else {
            callback.setEndpoints(endpoints, objectCached);
        }
    }

    private void getEndpointsTrace(Reference ref, EndpointI[] endpoints, boolean cached) {
        if (endpoints != null && endpoints.length > 0) {
            if (cached) {
                this.trace("found endpoints in locator table", ref, endpoints);
            } else {
                this.trace("retrieved endpoints from locator, adding to locator table", ref, endpoints);
            }
        } else {
            Instance instance = ref.getInstance();
            StringBuffer s = new StringBuffer();
            s.append("no endpoints configured for ");
            if (ref.getAdapterId().length() > 0) {
                s.append("adapter\n");
                s.append("adapter = " + ref.getAdapterId() + "\n");
            } else {
                s.append("object\n");
                s.append("object = " + instance.identityToString(ref.getIdentity()) + "\n");
            }
            instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
        }
    }

    static interface GetEndpointsCallback {
        public void setEndpoints(EndpointI[] var1, boolean var2);

        public void setException(LocalException var1);
    }
}

