/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.LocalException;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterI;
import Ice.SocketException;
import Ice.SyscallException;
import Ice.TimeoutException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.EndpointIHolder;
import IceInternal.EventHandler;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.ThreadPool;
import IceInternal.Transceiver;
import IceUtilInternal.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.channels.SelectableChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IncomingConnectionFactory
extends EventHandler
implements ConnectionI.StartCallback {
    private static final int StateActive = 0;
    private static final int StateHolding = 1;
    private static final int StateClosed = 2;
    private Acceptor _acceptor;
    private final Transceiver _transceiver;
    private EndpointI _endpoint;
    private ObjectAdapter _adapter;
    private final boolean _warn;
    private List<ConnectionI> _connections;
    private int _state;

    public synchronized void activate() {
        this.setState(0);
    }

    public synchronized void hold() {
        this.setState(1);
    }

    public synchronized void destroy() {
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilHolding() {
        LinkedList<ConnectionI> connections;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            while (this._state < 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            connections = new LinkedList<ConnectionI>(this._connections);
        }
        ListIterator p = connections.listIterator();
        while (p.hasNext()) {
            ConnectionI connection = (ConnectionI)p.next();
            connection.waitUntilHolding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        LinkedList<ConnectionI> connections = null;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            while (this._state != 2 || this._acceptor != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            this._adapter = null;
            if (this._connections != null) {
                connections = new LinkedList<ConnectionI>(this._connections);
            }
        }
        if (connections != null) {
            ListIterator p = connections.listIterator();
            while (p.hasNext()) {
                ConnectionI connection = (ConnectionI)p.next();
                connection.waitUntilFinished();
            }
        }
        incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            this._connections = null;
        }
    }

    public EndpointI endpoint() {
        return this._endpoint;
    }

    public synchronized LinkedList<ConnectionI> connections() {
        LinkedList<ConnectionI> connections = new LinkedList<ConnectionI>();
        ListIterator<ConnectionI> p = this._connections.listIterator();
        while (p.hasNext()) {
            ConnectionI connection = p.next();
            if (!connection.isActiveOrHolding()) continue;
            connections.add(connection);
        }
        return connections;
    }

    public void flushBatchRequests() {
        Iterator p = this.connections().iterator();
        while (p.hasNext()) {
            try {
                ((ConnectionI)p.next()).flushBatchRequests();
            }
            catch (LocalException localException) {}
        }
    }

    @Override
    public SelectableChannel fd() {
        assert (this._acceptor != null);
        return this._acceptor.fd();
    }

    @Override
    public boolean hasMoreData() {
        assert (this._acceptor != null);
        return false;
    }

    @Override
    public boolean datagram() {
        return this._endpoint.datagram();
    }

    @Override
    public boolean readable() {
        return false;
    }

    @Override
    public boolean read(BasicStream unused) {
        assert (false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void message(BasicStream unused, ThreadPool threadPool) {
        ConnectionI connection = null;
        IncomingConnectionFactory incomingConnectionFactory = this;
        // MONITORENTER : incomingConnectionFactory
        if (this._state != 0) {
            Thread.yield();
            // MONITOREXIT : incomingConnectionFactory
            threadPool.promoteFollower(null);
            return;
        }
        ListIterator<ConnectionI> p = this._connections.listIterator();
        while (p.hasNext()) {
            ConnectionI con = p.next();
            if (!con.isFinished()) continue;
            p.remove();
        }
        Transceiver transceiver = null;
        try {
            transceiver = this._acceptor.accept();
        }
        catch (SocketException ex) {
            if (Network.noMoreFds(ex.getCause())) {
                try {
                    String s = "fatal error: can't accept more connections:\n" + ex.getCause().getMessage();
                    s = s + '\n' + ((Object)this._acceptor).toString();
                    this._instance.initializationData().logger.error(s);
                }
                finally {
                    Runtime.getRuntime().halt(1);
                }
            }
            // MONITOREXIT : incomingConnectionFactory
            threadPool.promoteFollower(null);
            return;
        }
        catch (TimeoutException ex) {
            // MONITOREXIT : incomingConnectionFactory
            threadPool.promoteFollower(null);
            return;
        }
        catch (LocalException ex) {
            if (this._warn) {
                this.warning(ex);
            }
            // MONITOREXIT : incomingConnectionFactory
            threadPool.promoteFollower(null);
            return;
        }
        assert (transceiver != null);
        try {
            connection = new ConnectionI(this._instance, transceiver, this._endpoint, this._adapter);
        }
        catch (LocalException ex) {
            try {
                transceiver.close();
            }
            catch (LocalException exc) {
                // empty catch block
            }
            if (this._warn) {
                this.warning(ex);
            }
            // MONITOREXIT : incomingConnectionFactory
            threadPool.promoteFollower(null);
            return;
        }
        try {
            this._connections.add(connection);
            // MONITOREXIT : incomingConnectionFactory
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            threadPool.promoteFollower(null);
        }
        connection.start(this);
    }

    @Override
    public synchronized void finished(ThreadPool threadPool) {
        threadPool.promoteFollower(null);
        assert (threadPool == ((ObjectAdapterI)this._adapter).getThreadPool() && this._state == 2);
        this._acceptor.close();
        this._acceptor = null;
        this.notifyAll();
    }

    @Override
    public void exception(LocalException ex) {
        assert (false);
    }

    @Override
    public synchronized String toString() {
        if (this._transceiver != null) {
            return ((Object)this._transceiver).toString();
        }
        assert (this._acceptor != null);
        return ((Object)this._acceptor).toString();
    }

    @Override
    public synchronized void connectionStartCompleted(ConnectionI connection) {
        if (this._state == 0) {
            connection.activate();
        }
    }

    @Override
    public synchronized void connectionStartFailed(ConnectionI connection, LocalException ex) {
        if (this._state == 2) {
            return;
        }
        if (this._warn) {
            this.warning(ex);
        }
        if (connection.isFinished()) {
            this._connections.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncomingConnectionFactory(Instance instance, EndpointI endpoint, ObjectAdapter adapter, String adapterName) {
        block17: {
            super(instance);
            this._connections = new LinkedList<ConnectionI>();
            this._endpoint = endpoint;
            this._adapter = adapter;
            this._warn = this._instance.initializationData().properties.getPropertyAsInt("Ice.Warn.Connections") > 0;
            this._state = 1;
            DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
            if (defaultsAndOverrides.overrideTimeout) {
                this._endpoint = this._endpoint.timeout(defaultsAndOverrides.overrideTimeoutValue);
            }
            if (defaultsAndOverrides.overrideCompress) {
                this._endpoint = this._endpoint.compress(defaultsAndOverrides.overrideCompressValue);
            }
            ObjectAdapterI adapterImpl = (ObjectAdapterI)this._adapter;
            try {
                EndpointIHolder h = new EndpointIHolder();
                h.value = this._endpoint;
                this._transceiver = this._endpoint.transceiver(h);
                if (this._transceiver != null) {
                    ConnectionI connection;
                    this._endpoint = h.value;
                    try {
                        connection = new ConnectionI(this._instance, this._transceiver, this._endpoint, this._adapter);
                    }
                    catch (LocalException ex) {
                        try {
                            this._transceiver.close();
                        }
                        catch (LocalException exc) {
                            // empty catch block
                        }
                        throw ex;
                    }
                    connection.start(null);
                    this._connections.add(connection);
                    break block17;
                }
                h.value = this._endpoint;
                this._acceptor = this._endpoint.acceptor(h, adapterName);
                this._endpoint = h.value;
                assert (this._acceptor != null);
                this._acceptor.listen();
            }
            catch (Exception ex) {
                if (this._acceptor != null) {
                    try {
                        this._acceptor.close();
                    }
                    catch (LocalException e) {
                        // empty catch block
                    }
                }
                Object e = this;
                synchronized (e) {
                    this._state = 2;
                    this._acceptor = null;
                    this._connections = null;
                }
                if (ex instanceof LocalException) {
                    throw (LocalException)ex;
                }
                e = new SyscallException();
                ((Throwable)e).initCause(ex);
                throw e;
            }
        }
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._state == 2);
        Assert.FinalizerAssert(this._acceptor == null);
        Assert.FinalizerAssert(this._connections == null);
        super.finalize();
    }

    private void setState(int state) {
        if (this._state == state) {
            return;
        }
        switch (state) {
            case 0: {
                if (this._state != 1) {
                    return;
                }
                if (this._acceptor != null) {
                    ((ObjectAdapterI)this._adapter).getThreadPool()._register(this);
                }
                ListIterator<ConnectionI> p = this._connections.listIterator();
                while (p.hasNext()) {
                    ConnectionI connection = p.next();
                    connection.activate();
                }
                break;
            }
            case 1: {
                if (this._state != 0) {
                    return;
                }
                if (this._acceptor != null) {
                    ((ObjectAdapterI)this._adapter).getThreadPool().unregister(this);
                }
                ListIterator<ConnectionI> p = this._connections.listIterator();
                while (p.hasNext()) {
                    ConnectionI connection = p.next();
                    connection.hold();
                }
                break;
            }
            case 2: {
                if (this._acceptor != null) {
                    ((ObjectAdapterI)this._adapter).getThreadPool().finish(this);
                }
                ListIterator<ConnectionI> p = this._connections.listIterator();
                while (p.hasNext()) {
                    ConnectionI connection = p.next();
                    connection.destroy(0);
                }
                break;
            }
        }
        this._state = state;
        this.notifyAll();
    }

    private void warning(LocalException ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String s = "connection exception:\n" + sw.toString() + '\n' + ((Object)this._acceptor).toString();
        this._instance.initializationData().logger.warning(s);
    }

    private void error(String msg, Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String s = msg + ":\n" + this.toString() + "\n" + sw.toString();
        this._instance.initializationData().logger.error(s);
    }
}

