/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.AMISentCallback;
import Ice.BadMagicException;
import Ice.BooleanHolder;
import Ice.CloseConnectionException;
import Ice.CloseTimeoutException;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectTimeoutException;
import Ice.Connection;
import Ice.ConnectionLostException;
import Ice.ConnectionNotValidatedException;
import Ice.ConnectionTimeoutException;
import Ice.FeatureNotSupportedException;
import Ice.ForcedCloseConnectionException;
import Ice.Identity;
import Ice.IllegalMessageSizeException;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.Logger;
import Ice.MemoryLimitException;
import Ice.NegativeSizeException;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterI;
import Ice.ObjectPrx;
import Ice.OperationMode;
import Ice.SocketException;
import Ice.SyscallException;
import Ice.TimeoutException;
import Ice.UnknownException;
import Ice.UnknownMessageException;
import Ice.UnknownRequestIdException;
import Ice.UnsupportedEncodingException;
import Ice.UnsupportedProtocolException;
import IceInternal.BasicStream;
import IceInternal.BatchOutgoing;
import IceInternal.BatchOutgoingAsync;
import IceInternal.Buffer;
import IceInternal.ConnectionMonitor;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.EventHandler;
import IceInternal.Incoming;
import IceInternal.Instance;
import IceInternal.LocalExceptionWrapper;
import IceInternal.Outgoing;
import IceInternal.OutgoingAsync;
import IceInternal.OutgoingAsyncMessageCallback;
import IceInternal.OutgoingMessageCallback;
import IceInternal.Protocol;
import IceInternal.RequestHandler;
import IceInternal.SelectorThread;
import IceInternal.ServantManager;
import IceInternal.SocketStatus;
import IceInternal.ThreadPool;
import IceInternal.ThreadPoolWorkItem;
import IceInternal.Time;
import IceInternal.TraceLevels;
import IceInternal.TraceUtil;
import IceInternal.Transceiver;
import IceUtilInternal.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.channels.SelectableChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionI
extends EventHandler
implements Connection {
    public static final int ObjectAdapterDeactivated = 0;
    public static final int CommunicatorDestroyed = 1;
    private static final int StateNotInitialized = 0;
    private static final int StateNotValidated = 1;
    private static final int StateActive = 2;
    private static final int StateHolding = 3;
    private static final int StateClosing = 4;
    private static final int StateClosed = 5;
    private Transceiver _transceiver;
    private BooleanHolder _hasMoreData = new BooleanHolder(false);
    private String _desc;
    private final String _type;
    private final EndpointI _endpoint;
    private final SocketReadyCallback _socketReadyCallback = new SocketReadyCallback(this);
    private ObjectAdapter _adapter;
    private ServantManager _servantManager;
    private final Logger _logger;
    private final TraceLevels _traceLevels;
    private final ThreadPool _threadPool;
    private final SelectorThread _selectorThread;
    private StartCallback _startCallback = null;
    private final boolean _warn;
    private final int _acmTimeout;
    private long _acmAbsoluteTimeoutMillis;
    private final int _compressionLevel;
    private int _nextRequestId;
    private Map<Integer, Outgoing> _requests = new HashMap<Integer, Outgoing>();
    private Map<Integer, OutgoingAsync> _asyncRequests = new HashMap<Integer, OutgoingAsync>();
    private LocalException _exception;
    private boolean _batchAutoFlush;
    private BasicStream _batchStream;
    private boolean _batchStreamInUse;
    private int _batchRequestNum;
    private boolean _batchRequestCompress;
    private int _batchMarker;
    private LinkedList<OutgoingMessage> _sendStreams = new LinkedList();
    private boolean _sendInProgress;
    private List<OutgoingMessage> _sentCallbacks = new LinkedList<OutgoingMessage>();
    private ThreadPoolWorkItem _flushSentCallbacks = new ThreadPoolWorkItem(){

        public void execute(ThreadPool threadPool) {
            threadPool.promoteFollower(null);
            ConnectionI.this.flushSentCallbacks();
        }
    };
    private int _dispatchCount;
    private int _state;
    private long _stateTime;
    private Incoming _incomingCache;
    private Object _incomingCacheMutex = new Object();
    private Outgoing _outgoingCache;
    private Object _outgoingCacheMutex = new Object();
    private static boolean _compressionSupported = BasicStream.compressible();
    private boolean _overrideCompress;
    private boolean _overrideCompressValue;
    private boolean _cacheBuffers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartCallback callback) {
        try {
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                if (this._state == 5) {
                    assert (this._exception != null);
                    throw this._exception;
                }
                SocketStatus status = this.initialize();
                if (status == SocketStatus.Finished) {
                    status = this.validate();
                }
                if (status != SocketStatus.Finished) {
                    DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
                    int timeout = defaultsAndOverrides.overrideConnectTimeout ? defaultsAndOverrides.overrideConnectTimeoutValue : this._endpoint.timeout();
                    this._sendInProgress = true;
                    this._selectorThread._register(this._socketReadyCallback, status, timeout);
                    if (callback != null) {
                        this._startCallback = callback;
                        return;
                    }
                    while (this._state <= 1) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {}
                    }
                    if (this._state >= 4) {
                        assert (this._exception != null);
                        throw this._exception;
                    }
                }
            }
        }
        catch (LocalException ex) {
            this.exception(ex);
            if (callback != null) {
                callback.connectionStartFailed(this, this._exception);
                return;
            }
            this.waitUntilFinished();
            throw ex;
        }
        if (callback != null) {
            callback.connectionStartCompleted(this);
        }
    }

    public synchronized void activate() {
        if (this._state <= 1) {
            return;
        }
        if (this._acmTimeout > 0) {
            this._acmAbsoluteTimeoutMillis = Time.currentMonotonicTimeMillis() + (long)(this._acmTimeout * 1000);
        }
        this.setState(2);
    }

    public synchronized void hold() {
        if (this._state <= 1) {
            return;
        }
        this.setState(3);
    }

    public synchronized void destroy(int reason) {
        switch (reason) {
            case 0: {
                this.setState(4, new ObjectAdapterDeactivatedException());
                break;
            }
            case 1: {
                this.setState(4, new CommunicatorDestroyedException());
            }
        }
    }

    @Override
    public synchronized void close(boolean force) {
        if (force) {
            this.setState(5, new ForcedCloseConnectionException());
        } else {
            while (!this._requests.isEmpty() || !this._asyncRequests.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.setState(4, new CloseConnectionException());
        }
    }

    public synchronized boolean isActiveOrHolding() {
        return this._state > 1 && this._state < 4;
    }

    public synchronized boolean isFinished() {
        if (this._transceiver != null || this._dispatchCount != 0) {
            return false;
        }
        assert (this._state == 5);
        return true;
    }

    public synchronized void throwException() {
        if (this._exception != null) {
            assert (this._state >= 4);
            throw this._exception;
        }
    }

    public synchronized void waitUntilHolding() {
        while (this._state < 3 || this._dispatchCount > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void waitUntilFinished() {
        while (this._state < 4 || this._dispatchCount > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        while (this._transceiver != null) {
            try {
                if (this._state != 5 && this._endpoint.timeout() >= 0) {
                    long absoluteWaitTime = this._stateTime + (long)this._endpoint.timeout();
                    long waitTime = absoluteWaitTime - Time.currentMonotonicTimeMillis();
                    if (waitTime > 0L) {
                        this.wait(waitTime);
                        if (Time.currentMonotonicTimeMillis() < absoluteWaitTime) continue;
                        this.setState(5, new CloseTimeoutException());
                        continue;
                    }
                    this.setState(5, new CloseTimeoutException());
                    continue;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        assert (this._state == 5);
        this._adapter = null;
    }

    public synchronized void monitor() {
        if (this._state != 2) {
            return;
        }
        if (this._acmTimeout <= 0 || !this._requests.isEmpty() || !this._asyncRequests.isEmpty() || this._batchStreamInUse || !this._batchStream.isEmpty() || this._sendInProgress || this._dispatchCount > 0) {
            return;
        }
        if (Time.currentMonotonicTimeMillis() >= this._acmAbsoluteTimeoutMillis) {
            this.setState(4, new ConnectionTimeoutException());
        }
    }

    public synchronized boolean sendRequest(Outgoing out, boolean compress, boolean response) throws LocalExceptionWrapper {
        int requestId = 0;
        BasicStream os = out.os();
        if (this._exception != null) {
            throw new LocalExceptionWrapper(this._exception, true);
        }
        assert (this._state > 1);
        assert (this._state < 4);
        if (response) {
            if ((requestId = this._nextRequestId++) <= 0) {
                this._nextRequestId = 1;
                requestId = this._nextRequestId++;
            }
            os.pos(14);
            os.writeInt(requestId);
        }
        boolean sent = false;
        try {
            sent = this.sendMessage(new OutgoingMessage(out, out.os(), compress, response));
        }
        catch (LocalException ex) {
            this.setState(5, ex);
            assert (this._exception != null);
            throw this._exception;
        }
        if (response) {
            this._requests.put(requestId, out);
        }
        return sent;
    }

    public synchronized boolean sendAsyncRequest(OutgoingAsync out, boolean compress, boolean response) throws LocalExceptionWrapper {
        boolean sent;
        int requestId = 0;
        BasicStream os = out.__os();
        if (this._exception != null) {
            throw new LocalExceptionWrapper(this._exception, true);
        }
        assert (this._state > 1);
        assert (this._state < 4);
        if (response) {
            if ((requestId = this._nextRequestId++) <= 0) {
                this._nextRequestId = 1;
                requestId = this._nextRequestId++;
            }
            os.pos(14);
            os.writeInt(requestId);
        }
        try {
            sent = this.sendMessage(new OutgoingMessage(out, out.__os(), compress, response));
        }
        catch (LocalException ex) {
            this.setState(5, ex);
            assert (this._exception != null);
            throw this._exception;
        }
        if (response) {
            this._asyncRequests.put(requestId, out);
        }
        return sent;
    }

    public synchronized void prepareBatchRequest(BasicStream os) {
        while (this._batchStreamInUse && this._exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        if (this._exception != null) {
            throw this._exception;
        }
        assert (this._state > 1);
        assert (this._state < 4);
        if (this._batchStream.isEmpty()) {
            try {
                this._batchStream.writeBlob(Protocol.requestBatchHdr);
            }
            catch (LocalException ex) {
                this.setState(5, ex);
                throw ex;
            }
        }
        this._batchStreamInUse = true;
        this._batchMarker = this._batchStream.size();
        this._batchStream.swap(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBatchRequest(BasicStream os, boolean compress) {
        try {
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                this._batchStream.swap(os);
                if (this._exception != null) {
                    throw this._exception;
                }
                boolean flush = false;
                if (this._batchAutoFlush) {
                    try {
                        this._transceiver.checkSendSize(this._batchStream.getBuffer(), this._instance.messageSizeMax());
                    }
                    catch (LocalException ex) {
                        if (this._batchRequestNum > 0) {
                            flush = true;
                        }
                        throw ex;
                    }
                }
                if (flush) {
                    byte[] lastRequest = new byte[this._batchStream.size() - this._batchMarker];
                    Buffer buffer = this._batchStream.getBuffer();
                    buffer.b.position(this._batchMarker);
                    buffer.b.get(lastRequest);
                    this._batchStream.resize(this._batchMarker, false);
                    try {
                        this._batchStream.pos(14);
                        this._batchStream.writeInt(this._batchRequestNum);
                        OutgoingMessage message = new OutgoingMessage(this._batchStream, this._batchRequestCompress, true);
                        this.sendMessage(message);
                    }
                    catch (LocalException ex) {
                        this.setState(5, ex);
                        assert (this._exception != null);
                        throw this._exception;
                    }
                    this._batchStream = new BasicStream(this._instance, this._batchAutoFlush);
                    this._batchRequestNum = 0;
                    this._batchRequestCompress = false;
                    this._batchMarker = 0;
                    if (Protocol.requestBatchHdr.length + lastRequest.length > this._instance.messageSizeMax()) {
                        throw new MemoryLimitException();
                    }
                    this._batchStream.writeBlob(Protocol.requestBatchHdr);
                    this._batchStream.writeBlob(lastRequest);
                }
                ++this._batchRequestNum;
                if (compress) {
                    this._batchRequestCompress = true;
                }
                assert (this._batchStreamInUse);
                this._batchStreamInUse = false;
                this.notifyAll();
            }
        }
        catch (LocalException ex) {
            this.abortBatchRequest();
            throw ex;
        }
    }

    public synchronized void abortBatchRequest() {
        this._batchStream = new BasicStream(this._instance, this._batchAutoFlush);
        this._batchRequestNum = 0;
        this._batchRequestCompress = false;
        this._batchMarker = 0;
        assert (this._batchStreamInUse);
        this._batchStreamInUse = false;
        this.notifyAll();
    }

    @Override
    public void flushBatchRequests() {
        BatchOutgoing out = new BatchOutgoing(this, this._instance);
        out.invoke();
    }

    public synchronized boolean flushBatchRequests(BatchOutgoing out) {
        while (this._batchStreamInUse && this._exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        if (this._exception != null) {
            throw this._exception;
        }
        if (this._batchRequestNum == 0) {
            out.sent(false);
            return true;
        }
        this._batchStream.pos(14);
        this._batchStream.writeInt(this._batchRequestNum);
        this._batchStream.swap(out.os());
        boolean sent = false;
        try {
            OutgoingMessage message = new OutgoingMessage(out, out.os(), this._batchRequestCompress, false);
            sent = this.sendMessage(message);
        }
        catch (LocalException ex) {
            this.setState(5, ex);
            assert (this._exception != null);
            throw this._exception;
        }
        this._batchStream = new BasicStream(this._instance, this._batchAutoFlush);
        this._batchRequestNum = 0;
        this._batchRequestCompress = false;
        this._batchMarker = 0;
        return sent;
    }

    public synchronized boolean flushAsyncBatchRequests(BatchOutgoingAsync outAsync) {
        boolean sent;
        while (this._batchStreamInUse && this._exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        if (this._exception != null) {
            throw this._exception;
        }
        if (this._batchRequestNum == 0) {
            outAsync.__sent(this);
            return true;
        }
        this._batchStream.pos(14);
        this._batchStream.writeInt(this._batchRequestNum);
        this._batchStream.swap(outAsync.__os());
        try {
            OutgoingMessage message = new OutgoingMessage(outAsync, outAsync.__os(), this._batchRequestCompress, false);
            sent = this.sendMessage(message);
        }
        catch (LocalException ex) {
            this.setState(5, ex);
            assert (this._exception != null);
            throw this._exception;
        }
        this._batchStream = new BasicStream(this._instance, this._batchAutoFlush);
        this._batchRequestNum = 0;
        this._batchRequestCompress = false;
        this._batchMarker = 0;
        return sent;
    }

    public synchronized void sendResponse(BasicStream os, byte compressFlag) {
        assert (this._state > 1);
        try {
            if (--this._dispatchCount == 0) {
                this.notifyAll();
            }
            if (this._state == 5) {
                assert (this._exception != null);
                throw this._exception;
            }
            this.sendMessage(new OutgoingMessage(os, compressFlag != 0, true));
            if (this._state == 4 && this._dispatchCount == 0) {
                this.initiateShutdown();
            }
            if (this._acmTimeout > 0) {
                this._acmAbsoluteTimeoutMillis = Time.currentMonotonicTimeMillis() + (long)(this._acmTimeout * 1000);
            }
        }
        catch (LocalException ex) {
            this.setState(5, ex);
        }
    }

    public synchronized void sendNoResponse() {
        assert (this._state > 1);
        try {
            if (--this._dispatchCount == 0) {
                this.notifyAll();
            }
            if (this._state == 5) {
                assert (this._exception != null);
                throw this._exception;
            }
            if (this._state == 4 && this._dispatchCount == 0) {
                this.initiateShutdown();
            }
            if (this._acmTimeout > 0) {
                this._acmAbsoluteTimeoutMillis = Time.currentMonotonicTimeMillis() + (long)(this._acmTimeout * 1000);
            }
        }
        catch (LocalException ex) {
            this.setState(5, ex);
        }
    }

    public EndpointI endpoint() {
        return this._endpoint;
    }

    @Override
    public synchronized void setAdapter(ObjectAdapter adapter) {
        if (this._state == 4 || this._state == 5) {
            assert (this._exception != null);
            throw this._exception;
        }
        if (this._state <= 1) {
            return;
        }
        assert (this._state < 4);
        this._adapter = adapter;
        if (this._adapter != null) {
            this._servantManager = ((ObjectAdapterI)this._adapter).getServantManager();
            if (this._servantManager == null) {
                this._adapter = null;
            }
        } else {
            this._servantManager = null;
        }
    }

    @Override
    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }

    @Override
    public ObjectPrx createProxy(Identity ident) {
        return this._instance.proxyFactory().referenceToProxy(this._instance.referenceFactory().create(ident, this));
    }

    @Override
    public SelectableChannel fd() {
        return this._transceiver.fd();
    }

    @Override
    public boolean hasMoreData() {
        return this._hasMoreData.value;
    }

    @Override
    public boolean datagram() {
        return this._endpoint.datagram();
    }

    @Override
    public boolean readable() {
        return true;
    }

    @Override
    public boolean read(BasicStream stream) {
        assert (this._transceiver != null);
        return this._transceiver.read(stream.getBuffer(), this._hasMoreData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(BasicStream stream, ThreadPool threadPool) {
        MessageInfo info = new MessageInfo(stream);
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            threadPool.promoteFollower(this);
            if (this._state != 5) {
                this.parseMessage(info);
            }
            if (this._state == 5) {
                return;
            }
        }
        if (info.outAsync != null) {
            info.outAsync.__finished(info.stream);
        }
        this.invokeAll(info.stream, info.invokeNum, info.requestId, info.compress, info.servantManager, info.adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(ThreadPool threadPool) {
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            assert (threadPool == this._threadPool && this._state == 5 && !this._sendInProgress);
            threadPool.promoteFollower(null);
        }
        if (this._startCallback != null) {
            this._startCallback.connectionStartFailed(this, this._exception);
            this._startCallback = null;
        }
        Iterator p = this._sendStreams.iterator();
        while (p.hasNext()) {
            ((OutgoingMessage)p.next()).finished(this._exception);
        }
        this._sendStreams.clear();
        Iterator<Outgoing> q = this._requests.values().iterator();
        while (q.hasNext()) {
            q.next().finished(this._exception);
        }
        this._requests.clear();
        Iterator<OutgoingAsync> r = this._asyncRequests.values().iterator();
        while (r.hasNext()) {
            r.next().__finished(this._exception);
        }
        this._asyncRequests.clear();
        ConnectionI connectionI2 = this;
        synchronized (connectionI2) {
            try {
                this._transceiver.close();
            }
            finally {
                this._transceiver = null;
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized void exception(LocalException ex) {
        this.setState(5, ex);
    }

    public synchronized void invokeException(LocalException ex, int invokeNum) {
        this.setState(5, ex);
        if (invokeNum > 0) {
            assert (this._dispatchCount > 0);
            this._dispatchCount -= invokeNum;
            assert (this._dispatchCount >= 0);
            if (this._dispatchCount == 0) {
                this.notifyAll();
            }
        }
    }

    @Override
    public String type() {
        return this._type;
    }

    @Override
    public int timeout() {
        return this._endpoint.timeout();
    }

    @Override
    public String toString() {
        return this._toString();
    }

    @Override
    public String _toString() {
        return this._desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketStatus socketReady() {
        StartCallback callback = null;
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            assert (this._sendInProgress);
            if (this._state == 5) {
                return SocketStatus.Finished;
            }
            try {
                if (!this._sendStreams.isEmpty()) {
                    if (!this.send()) {
                        return SocketStatus.NeedWrite;
                    }
                    assert (this._sendStreams.isEmpty());
                } else {
                    SocketStatus status;
                    if (this._state == 0 && (status = this.initialize()) != SocketStatus.Finished) {
                        return status;
                    }
                    if (this._state <= 1 && (status = this.validate()) != SocketStatus.Finished) {
                        return status;
                    }
                    callback = this._startCallback;
                    this._startCallback = null;
                }
            }
            catch (LocalException ex) {
                this.setState(5, ex);
                return SocketStatus.Finished;
            }
            assert (this._sendStreams.isEmpty());
            this._selectorThread.unregister(this._socketReadyCallback);
            this._sendInProgress = false;
            if (this._acmTimeout > 0) {
                this._acmAbsoluteTimeoutMillis = Time.currentMonotonicTimeMillis() + (long)(this._acmTimeout * 1000);
            }
        }
        if (callback != null) {
            callback.connectionStartCompleted(this);
        }
        return SocketStatus.Finished;
    }

    public synchronized void socketFinished() {
        assert (this._sendInProgress && this._state == 5);
        this._sendInProgress = false;
        this._threadPool.finish(this);
    }

    public synchronized void socketTimeout() {
        if (this._state <= 1) {
            this.setState(5, new ConnectTimeoutException());
        } else if (this._state <= 4) {
            this.setState(5, new TimeoutException());
        }
    }

    public Transceiver getTransceiver() {
        return this._transceiver;
    }

    public ConnectionI(Instance instance, Transceiver transceiver, EndpointI endpoint, ObjectAdapter adapter) {
        super(instance);
        InitializationData initData = instance.initializationData();
        this._transceiver = transceiver;
        this._desc = ((Object)transceiver).toString();
        this._type = transceiver.type();
        this._endpoint = endpoint;
        this._adapter = adapter;
        this._logger = initData.logger;
        this._traceLevels = instance.traceLevels();
        this._warn = initData.properties.getPropertyAsInt("Ice.Warn.Connections") > 0;
        this._cacheBuffers = initData.properties.getPropertyAsIntWithDefault("Ice.CacheMessageBuffers", 1) == 1;
        this._acmAbsoluteTimeoutMillis = 0L;
        this._nextRequestId = 1;
        this._batchAutoFlush = initData.properties.getPropertyAsIntWithDefault("Ice.BatchAutoFlush", 1) > 0;
        this._batchStream = new BasicStream(instance, this._batchAutoFlush);
        this._batchStreamInUse = false;
        this._batchRequestNum = 0;
        this._batchRequestCompress = false;
        this._batchMarker = 0;
        this._sendInProgress = false;
        this._dispatchCount = 0;
        this._state = 0;
        this._stateTime = Time.currentMonotonicTimeMillis();
        this._acmTimeout = this._endpoint.datagram() ? 0 : (this._adapter != null ? this._instance.serverACM() : this._instance.clientACM());
        int compressionLevel = initData.properties.getPropertyAsIntWithDefault("Ice.Compression.Level", 1);
        if (compressionLevel < 1) {
            compressionLevel = 1;
        } else if (compressionLevel > 9) {
            compressionLevel = 9;
        }
        this._compressionLevel = compressionLevel;
        this._servantManager = this._adapter != null ? ((ObjectAdapterI)this._adapter).getServantManager() : null;
        try {
            this._threadPool = this._adapter != null ? ((ObjectAdapterI)this._adapter).getThreadPool() : this._instance.clientThreadPool();
            this._selectorThread = this._instance.selectorThread();
            this._overrideCompress = this._instance.defaultsAndOverrides().overrideCompress;
            this._overrideCompressValue = this._instance.defaultsAndOverrides().overrideCompressValue;
        }
        catch (LocalException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SyscallException e = new SyscallException();
            e.initCause(ex);
            throw e;
        }
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._startCallback == null);
        Assert.FinalizerAssert(this._state == 5);
        Assert.FinalizerAssert(this._transceiver == null);
        Assert.FinalizerAssert(this._dispatchCount == 0);
        Assert.FinalizerAssert(this._sendStreams.isEmpty());
        Assert.FinalizerAssert(this._requests.isEmpty());
        Assert.FinalizerAssert(this._asyncRequests.isEmpty());
        super.finalize();
    }

    private void setState(int state, LocalException ex) {
        assert (state == 4 || state == 5);
        if (this._state == state) {
            return;
        }
        if (this._exception == null) {
            this._exception = ex;
            if (!(!this._warn || this._state <= 1 || this._exception instanceof CloseConnectionException || this._exception instanceof ForcedCloseConnectionException || this._exception instanceof ConnectionTimeoutException || this._exception instanceof CommunicatorDestroyedException || this._exception instanceof ObjectAdapterDeactivatedException || this._exception instanceof ConnectionLostException && this._state == 4)) {
                this.warning("connection exception", this._exception);
            }
        }
        this.setState(state);
    }

    private void setState(int state) {
        if (this._endpoint.datagram() && state == 4) {
            state = 5;
        }
        if (this._state <= 1 && state == 4) {
            state = 5;
        }
        if (this._state == state) {
            return;
        }
        switch (state) {
            case 0: {
                assert (false);
                break;
            }
            case 1: {
                if (this._state == 0) break;
                assert (this._state == 5);
                return;
            }
            case 2: {
                if (this._state != 3 && this._state != 1) {
                    return;
                }
                this._threadPool._register(this);
                break;
            }
            case 3: {
                if (this._state != 2 && this._state != 1) {
                    return;
                }
                this._threadPool.unregister(this);
                break;
            }
            case 4: {
                if (this._state == 5) {
                    return;
                }
                this._threadPool._register(this);
                break;
            }
            case 5: {
                if (this._sendInProgress) {
                    this._selectorThread.finish(this._socketReadyCallback);
                    this._threadPool.unregister(this);
                    break;
                }
                this._threadPool.finish(this);
            }
        }
        ConnectionMonitor connectionMonitor = this._instance.connectionMonitor();
        if (connectionMonitor != null) {
            if (state == 2) {
                connectionMonitor.add(this);
            } else if (this._state == 2) {
                connectionMonitor.remove(this);
            }
        }
        this._state = state;
        this._stateTime = Time.currentMonotonicTimeMillis();
        this.notifyAll();
        if (this._state == 4 && this._dispatchCount == 0) {
            try {
                this.initiateShutdown();
            }
            catch (LocalException ex) {
                this.setState(5, ex);
            }
        }
    }

    private void initiateShutdown() {
        assert (this._state == 4);
        assert (this._dispatchCount == 0);
        if (!this._endpoint.datagram()) {
            BasicStream os = new BasicStream(this._instance);
            os.writeBlob(Protocol.magic);
            os.writeByte((byte)1);
            os.writeByte((byte)0);
            os.writeByte((byte)1);
            os.writeByte((byte)0);
            os.writeByte((byte)4);
            os.writeByte(_compressionSupported ? (byte)1 : 0);
            os.writeInt(14);
            this.sendMessage(new OutgoingMessage(os, false, false));
        }
    }

    private SocketStatus initialize() {
        SocketStatus status = this._transceiver.initialize();
        if (status != SocketStatus.Finished) {
            return status;
        }
        this._desc = ((Object)this._transceiver).toString();
        this.setState(1);
        return SocketStatus.Finished;
    }

    private SocketStatus validate() {
        if (!this._endpoint.datagram()) {
            if (this._adapter != null) {
                BasicStream os = this._stream;
                if (os.size() == 0) {
                    os.writeBlob(Protocol.magic);
                    os.writeByte((byte)1);
                    os.writeByte((byte)0);
                    os.writeByte((byte)1);
                    os.writeByte((byte)0);
                    os.writeByte((byte)3);
                    os.writeByte((byte)0);
                    os.writeInt(14);
                    TraceUtil.traceSend(os, this._logger, this._traceLevels);
                    os.prepareWrite();
                }
                if (!this._transceiver.write(os.getBuffer())) {
                    return SocketStatus.NeedWrite;
                }
            } else {
                BasicStream is = this._stream;
                if (is.size() == 0) {
                    is.resize(14, true);
                    is.pos(0);
                }
                if (!this._transceiver.read(is.getBuffer(), this._hasMoreData)) {
                    return SocketStatus.NeedRead;
                }
                assert (is.pos() == 14);
                is.pos(0);
                byte[] m = is.readBlob(4);
                if (m[0] != Protocol.magic[0] || m[1] != Protocol.magic[1] || m[2] != Protocol.magic[2] || m[3] != Protocol.magic[3]) {
                    BadMagicException ex = new BadMagicException();
                    ex.badMagic = m;
                    throw ex;
                }
                int pMajor = is.readByte();
                int pMinor = is.readByte();
                if (pMajor != 1) {
                    UnsupportedProtocolException e = new UnsupportedProtocolException();
                    e.badMajor = pMajor < 0 ? pMajor + 255 : pMajor;
                    e.badMinor = pMinor < 0 ? pMinor + 255 : pMinor;
                    e.major = 1;
                    e.minor = 0;
                    throw e;
                }
                int eMajor = is.readByte();
                int eMinor = is.readByte();
                if (eMajor != 1) {
                    UnsupportedEncodingException e = new UnsupportedEncodingException();
                    e.badMajor = eMajor < 0 ? eMajor + 255 : eMajor;
                    e.badMinor = eMinor < 0 ? eMinor + 255 : eMinor;
                    e.major = 1;
                    e.minor = 0;
                    throw e;
                }
                byte messageType = is.readByte();
                if (messageType != 3) {
                    throw new ConnectionNotValidatedException();
                }
                byte compress = is.readByte();
                int size = is.readInt();
                if (size != 14) {
                    throw new IllegalMessageSizeException();
                }
                TraceUtil.traceRecv(is, this._logger, this._traceLevels);
            }
        }
        this._stream.reset();
        this.setState(3);
        return SocketStatus.Finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean send() {
        assert (this._transceiver != null);
        assert (!this._sendStreams.isEmpty());
        boolean flushSentCallbacks = this._sentCallbacks.isEmpty();
        try {
            while (!this._sendStreams.isEmpty()) {
                OutgoingMessage message = this._sendStreams.getFirst();
                if (!message.prepared) {
                    BasicStream stream = message.stream;
                    boolean compress = this._overrideCompress ? this._overrideCompressValue : message.compress;
                    message.stream = this.doCompress(stream, compress);
                    message.stream.prepareWrite();
                    message.prepared = true;
                    if (message.outAsync != null) {
                        TraceUtil.trace("sending asynchronous request", stream, this._logger, this._traceLevels);
                    } else {
                        TraceUtil.traceSend(stream, this._logger, this._traceLevels);
                    }
                }
                if (!this._transceiver.write(message.stream.getBuffer())) {
                    boolean bl = false;
                    return bl;
                }
                message.sent(this, true);
                if (message.outAsync instanceof AMISentCallback) {
                    this._sentCallbacks.add(message);
                }
                this._sendStreams.removeFirst();
            }
        }
        finally {
            if (flushSentCallbacks && !this._sentCallbacks.isEmpty()) {
                this._threadPool.execute(this._flushSentCallbacks);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSentCallbacks() {
        List<OutgoingMessage> sentCallbacks;
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            assert (this._sentCallbacks != null && !this._sentCallbacks.isEmpty());
            sentCallbacks = this._sentCallbacks;
            this._sentCallbacks = new LinkedList<OutgoingMessage>();
        }
        for (OutgoingMessage message : sentCallbacks) {
            message.outAsync.__sent(this._instance);
        }
    }

    private boolean sendMessage(OutgoingMessage message) {
        assert (this._state != 5);
        if (this._sendInProgress) {
            message.adopt();
            this._sendStreams.addLast(message);
            return false;
        }
        assert (!this._sendInProgress);
        assert (!message.prepared);
        BasicStream stream = message.stream;
        boolean compress = this._overrideCompress ? this._overrideCompressValue : message.compress;
        message.stream = this.doCompress(stream, compress);
        message.stream.prepareWrite();
        message.prepared = true;
        if (message.outAsync != null) {
            TraceUtil.trace("sending asynchronous request", stream, this._logger, this._traceLevels);
        } else {
            TraceUtil.traceSend(stream, this._logger, this._traceLevels);
        }
        if (this._transceiver.write(message.stream.getBuffer())) {
            message.sent(this, false);
            if (this._acmTimeout > 0) {
                this._acmAbsoluteTimeoutMillis = Time.currentMonotonicTimeMillis() + (long)(this._acmTimeout * 1000);
            }
            return true;
        }
        this._sendStreams.addLast(message);
        this._sendInProgress = true;
        message.adopt();
        this._selectorThread._register(this._socketReadyCallback, SocketStatus.NeedWrite, this._endpoint.timeout());
        return false;
    }

    private BasicStream doCompress(BasicStream uncompressed, boolean compress) {
        BasicStream cstream;
        if (_compressionSupported && compress && uncompressed.size() >= 100 && (cstream = uncompressed.compress(14, this._compressionLevel)) != null) {
            cstream.pos(9);
            cstream.writeByte((byte)2);
            cstream.pos(10);
            cstream.writeInt(cstream.size());
            uncompressed.pos(9);
            uncompressed.writeByte((byte)2);
            uncompressed.writeInt(cstream.size());
            return cstream;
        }
        uncompressed.pos(9);
        uncompressed.writeByte((byte)(_compressionSupported && compress ? 1 : 0));
        uncompressed.pos(10);
        uncompressed.writeInt(uncompressed.size());
        return uncompressed;
    }

    private void parseMessage(MessageInfo info) {
        assert (this._state > 1 && this._state < 5);
        if (this._acmTimeout > 0) {
            this._acmAbsoluteTimeoutMillis = Time.currentMonotonicTimeMillis() + (long)(this._acmTimeout * 1000);
        }
        try {
            assert (info.stream.pos() == info.stream.size());
            info.stream.pos(8);
            byte messageType = info.stream.readByte();
            info.compress = info.stream.readByte();
            if (info.compress == 2) {
                if (_compressionSupported) {
                    BasicStream ustream = info.stream.uncompress(14);
                    if (ustream != info.stream) {
                        info.stream = ustream;
                    }
                } else {
                    FeatureNotSupportedException ex = new FeatureNotSupportedException();
                    ex.unsupportedFeature = "Cannot uncompress compressed message: org.apache.tools.bzip2.CBZip2OutputStream was not found";
                    throw ex;
                }
            }
            info.stream.pos(14);
            switch (messageType) {
                case 4: {
                    TraceUtil.traceRecv(info.stream, this._logger, this._traceLevels);
                    if (this._endpoint.datagram()) {
                        if (this._warn) {
                            this._logger.warning("ignoring close connection message for datagram connection:\n" + this._desc);
                        }
                        break;
                    }
                    this.setState(5, new CloseConnectionException());
                    break;
                }
                case 0: {
                    if (this._state == 4) {
                        TraceUtil.trace("received request during closing\n(ignored by server, client will retry)", info.stream, this._logger, this._traceLevels);
                        break;
                    }
                    TraceUtil.traceRecv(info.stream, this._logger, this._traceLevels);
                    info.requestId = info.stream.readInt();
                    info.invokeNum = 1;
                    info.servantManager = this._servantManager;
                    info.adapter = this._adapter;
                    ++this._dispatchCount;
                    break;
                }
                case 1: {
                    if (this._state == 4) {
                        TraceUtil.trace("received batch request during closing\n(ignored by server, client will retry)", info.stream, this._logger, this._traceLevels);
                        break;
                    }
                    TraceUtil.traceRecv(info.stream, this._logger, this._traceLevels);
                    info.invokeNum = info.stream.readInt();
                    if (info.invokeNum < 0) {
                        info.invokeNum = 0;
                        throw new NegativeSizeException();
                    }
                    info.servantManager = this._servantManager;
                    info.adapter = this._adapter;
                    this._dispatchCount += info.invokeNum;
                    break;
                }
                case 2: {
                    TraceUtil.traceRecv(info.stream, this._logger, this._traceLevels);
                    info.requestId = info.stream.readInt();
                    Outgoing out = this._requests.remove(info.requestId);
                    if (out != null) {
                        out.finished(info.stream);
                        break;
                    }
                    info.outAsync = this._asyncRequests.remove(info.requestId);
                    if (info.outAsync == null) {
                        throw new UnknownRequestIdException();
                    }
                    break;
                }
                case 3: {
                    TraceUtil.traceRecv(info.stream, this._logger, this._traceLevels);
                    if (this._warn) {
                        this._logger.warning("ignoring unexpected validate connection message:\n" + this._desc);
                    }
                    break;
                }
                default: {
                    TraceUtil.trace("received unknown message\n(invalid, closing connection)", info.stream, this._logger, this._traceLevels);
                    throw new UnknownMessageException();
                }
            }
        }
        catch (SocketException ex) {
            this.setState(5, ex);
        }
        catch (LocalException ex) {
            if (this._endpoint.datagram()) {
                if (this._warn) {
                    this._logger.warning("udp connection exception:\n" + ex + this._desc);
                }
            }
            this.setState(5, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeAll(BasicStream stream, int invokeNum, int requestId, byte compress, ServantManager servantManager, ObjectAdapter adapter) {
        Incoming in = null;
        try {
            while (invokeNum > 0) {
                boolean response = !this._endpoint.datagram() && requestId != 0;
                in = this.getIncoming(adapter, response, compress, requestId);
                BasicStream is = in.is();
                stream.swap(is);
                BasicStream os = in.os();
                if (response) {
                    assert (invokeNum == 1);
                    os.writeBlob(Protocol.replyHdr);
                    os.writeInt(requestId);
                }
                in.invoke(servantManager);
                if (--invokeNum > 0) {
                    stream.swap(is);
                }
                this.reclaimIncoming(in);
                in = null;
            }
            if (in == null) return;
        }
        catch (LocalException ex) {
            this.invokeException(ex, invokeNum);
            return;
            catch (AssertionError ex2) {
                UnknownException uex = new UnknownException();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ((Throwable)((Object)ex2)).printStackTrace(pw);
                pw.flush();
                uex.unknown = sw.toString();
                this._logger.error(uex.unknown);
                this.invokeException(uex, invokeNum);
                if (in == null) return;
                this.reclaimIncoming(in);
                return;
            }
            finally {
                if (in != null) {
                    this.reclaimIncoming(in);
                }
            }
        }
        this.reclaimIncoming(in);
    }

    private void warning(String msg, Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String s = msg + ":\n" + this._desc + "\n" + sw.toString();
        this._logger.warning(s);
    }

    private void error(String msg, Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String s = msg + ":\n" + this._desc + "\n" + sw.toString();
        this._logger.error(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Incoming getIncoming(ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        Incoming in = null;
        if (this._cacheBuffers) {
            Object object = this._incomingCacheMutex;
            synchronized (object) {
                if (this._incomingCache == null) {
                    in = new Incoming(this._instance, this, adapter, response, compress, requestId);
                } else {
                    in = this._incomingCache;
                    this._incomingCache = this._incomingCache.next;
                    in.reset(this._instance, this, adapter, response, compress, requestId);
                    in.next = null;
                }
            }
        } else {
            in = new Incoming(this._instance, this, adapter, response, compress, requestId);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reclaimIncoming(Incoming in) {
        if (this._cacheBuffers) {
            Object object = this._incomingCacheMutex;
            synchronized (object) {
                in.next = this._incomingCache;
                this._incomingCache = in;
                this._incomingCache.reclaim();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outgoing getOutgoing(RequestHandler handler, String operation, OperationMode mode, Map<String, String> context) throws LocalExceptionWrapper {
        Outgoing out = null;
        if (this._cacheBuffers) {
            Object object = this._outgoingCacheMutex;
            synchronized (object) {
                if (this._outgoingCache == null) {
                    out = new Outgoing(handler, operation, mode, context);
                } else {
                    out = this._outgoingCache;
                    this._outgoingCache = this._outgoingCache.next;
                    out.reset(handler, operation, mode, context);
                    out.next = null;
                }
            }
        } else {
            out = new Outgoing(handler, operation, mode, context);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reclaimOutgoing(Outgoing out) {
        if (this._cacheBuffers) {
            out.reclaim();
            Object object = this._outgoingCacheMutex;
            synchronized (object) {
                out.next = this._outgoingCache;
                this._outgoingCache = out;
            }
        }
    }

    static class SocketReadyCallback
    extends SelectorThread.SocketReadyCallback {
        private final ConnectionI _connection;

        public SocketReadyCallback(ConnectionI connection) {
            this._connection = connection;
        }

        public SelectableChannel fd() {
            return this._connection.fd();
        }

        public boolean hasMoreData() {
            return this._connection.hasMoreData();
        }

        public SocketStatus socketReady() {
            return this._connection.socketReady();
        }

        public void socketFinished() {
            this._connection.socketFinished();
        }

        public void runTimerTask() {
            this._connection.socketTimeout();
        }
    }

    private static class OutgoingMessage {
        public BasicStream stream;
        public OutgoingMessageCallback out;
        public OutgoingAsyncMessageCallback outAsync;
        public boolean compress;
        public boolean response;
        boolean adopt;
        boolean prepared;

        OutgoingMessage(BasicStream stream, boolean compress, boolean adopt) {
            this.stream = stream;
            this.compress = compress;
            this.adopt = adopt;
        }

        OutgoingMessage(OutgoingMessageCallback out, BasicStream stream, boolean compress, boolean resp) {
            this.stream = stream;
            this.compress = compress;
            this.out = out;
            this.response = resp;
        }

        OutgoingMessage(OutgoingAsyncMessageCallback out, BasicStream stream, boolean compress, boolean resp) {
            this.stream = stream;
            this.compress = compress;
            this.outAsync = out;
            this.response = resp;
        }

        public void adopt() {
            if (this.adopt) {
                BasicStream stream = new BasicStream(this.stream.instance());
                stream.swap(this.stream);
                this.stream = stream;
                this.adopt = false;
            }
        }

        public void sent(ConnectionI connection, boolean notify) {
            if (this.out != null) {
                this.out.sent(notify);
            } else if (this.outAsync != null) {
                this.outAsync.__sent(connection);
            }
        }

        public void finished(LocalException ex) {
            if (!this.response) {
                if (this.out != null) {
                    this.out.finished(ex);
                } else if (this.outAsync != null) {
                    this.outAsync.__finished(ex);
                }
            }
        }
    }

    private static class MessageInfo {
        BasicStream stream;
        int invokeNum;
        int requestId;
        byte compress;
        ServantManager servantManager;
        ObjectAdapter adapter;
        OutgoingAsync outAsync;

        MessageInfo(BasicStream stream) {
            this.stream = stream;
        }
    }

    public static interface StartCallback {
        public void connectionStartCompleted(ConnectionI var1);

        public void connectionStartFailed(ConnectionI var1, LocalException var2);
    }
}

