/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.Catalog;
import Freeze.CatalogData;
import Freeze.Connection;
import Freeze.DatabaseException;
import Freeze.DeadlockException;
import Freeze.EvictorI;
import Freeze.Index;
import Freeze.NotFoundException;
import Freeze.ObjectRecord;
import Freeze.Transaction;
import Freeze.TransactionI;
import Freeze.Util;
import Ice.Communicator;
import Ice.Identity;
import Ice.ObjectFactory;
import Ice.Properties;
import IceInternal.BasicStream;
import IceInternal.Buffer;
import IceUtil.Cache;
import IceUtil.Store;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.Environment;
import com.sleepycat.db.OperationStatus;
import java.io.FileNotFoundException;
import java.util.List;

class ObjectStore
implements Store {
    private final Cache _cache = new Cache(this);
    private final String _facet;
    private final String _dbName;
    private final EvictorI _evictor;
    private final List _indices;
    private final Communicator _communicator;
    private Database _db;
    private Ice.Object _sampleServant;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectStore(String facet, String facetType, boolean createDb, EvictorI evictor, List indices, boolean populateEmptyIndices) {
        this._facet = facet;
        this._evictor = evictor;
        this._indices = indices;
        this._communicator = evictor.communicator();
        this._dbName = facet.equals("") ? "$default" : facet;
        if (facetType != null) {
            ObjectFactory factory = this._communicator.findObjectFactory(facetType);
            if (factory == null) {
                throw new DatabaseException(this._evictor.errorPrefix() + "No object factory registered for type-id '" + facetType + "'");
            }
            this._sampleServant = factory.create(facetType);
        }
        Connection connection = Util.createConnection(this._communicator, evictor.dbEnv().getEnvName());
        try {
            int pageSize;
            boolean checksum;
            Catalog catalog = new Catalog(connection, Util.catalogName(), true);
            CatalogData catalogData = (CatalogData)catalog.get(evictor.filename());
            if (catalogData != null && !catalogData.evictor) {
                DatabaseException ex = new DatabaseException();
                ex.message = this._evictor.errorPrefix() + evictor.filename() + " is not an evictor database";
                throw ex;
            }
            Environment dbEnv = evictor.dbEnv().getEnv();
            DatabaseConfig config = new DatabaseConfig();
            config.setType(DatabaseType.BTREE);
            config.setAllowCreate(createDb);
            Properties properties = this._evictor.communicator().getProperties();
            String propPrefix = "Freeze.Evictor." + this._evictor.filename() + ".";
            int btreeMinKey = properties.getPropertyAsInt(propPrefix + this._dbName + ".BtreeMinKey");
            if (btreeMinKey > 2) {
                if (this._evictor.trace() >= 1) {
                    this._evictor.communicator().getLogger().trace("Freeze.Evictor", "Setting \"" + this._evictor.filename() + "." + this._dbName + "\"'s btree minkey to " + btreeMinKey);
                }
                config.setBtreeMinKey(btreeMinKey);
            }
            boolean bl = checksum = properties.getPropertyAsInt(propPrefix + "Checksum") > 0;
            if (checksum) {
                if (this._evictor.trace() >= 1) {
                    this._evictor.communicator().getLogger().trace("Freeze.Evictor", "Turning checksum on for \"" + this._evictor.filename() + "\"");
                }
                config.setChecksum(true);
            }
            if ((pageSize = properties.getPropertyAsInt(propPrefix + "PageSize")) > 0) {
                if (this._evictor.trace() >= 1) {
                    this._evictor.communicator().getLogger().trace("Freeze.Evictor", "Setting \"" + this._evictor.filename() + "\"'s pagesize to " + pageSize);
                }
                config.setPageSize(pageSize);
            }
            try {
                Transaction tx = connection.beginTransaction();
                com.sleepycat.db.Transaction txn = Util.getTxn(tx);
                this._db = dbEnv.openDatabase(txn, evictor.filename(), this._dbName, config);
                for (Index index : this._indices) {
                    index.associate(this, txn, createDb, populateEmptyIndices);
                }
                if (catalogData == null) {
                    catalogData = new CatalogData();
                    catalogData.evictor = true;
                    catalog.put(evictor.filename(), catalogData);
                }
                tx.commit();
            }
            catch (FileNotFoundException dx) {
                NotFoundException ex = new NotFoundException();
                ex.initCause(dx);
                ex.message = this._evictor.errorPrefix() + "Db.open: " + dx.getMessage();
                throw ex;
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = this._evictor.errorPrefix() + "Db.open: " + dx.getMessage();
                throw ex;
            }
            finally {
                Transaction tx = connection.currentTransaction();
                if (tx != null) {
                    try {
                        tx.rollback();
                    }
                    catch (DatabaseException de) {}
                }
            }
        }
        finally {
            connection.close();
        }
    }

    void close() {
        try {
            this._db.close();
            for (Index index : this._indices) {
                index.close();
            }
            this._indices.clear();
        }
        catch (com.sleepycat.db.DatabaseException dx) {
            DatabaseException ex = new DatabaseException();
            ex.initCause(dx);
            ex.message = this._evictor.errorPrefix() + "Db.close: " + dx.getMessage();
            throw ex;
        }
        this._db = null;
    }

    boolean dbHasObject(Identity ident, TransactionI transaction) {
        com.sleepycat.db.Transaction tx = null;
        if (transaction != null && (tx = transaction.dbTxn()) == null) {
            throw new DatabaseException(this._evictor.errorPrefix() + "inactive transaction");
        }
        byte[] key = ObjectStore.marshalKey(ident, this._communicator);
        DatabaseEntry dbKey = new DatabaseEntry(key);
        DatabaseEntry dbValue = new DatabaseEntry();
        dbValue.setPartial(true);
        while (true) {
            try {
                OperationStatus err = this._db.get(tx, dbKey, dbValue, null);
                if (err == OperationStatus.SUCCESS) {
                    return true;
                }
                if (err == OperationStatus.NOTFOUND) {
                    return false;
                }
                throw new DatabaseException();
            }
            catch (com.sleepycat.db.DeadlockException dx) {
                if (!this._evictor.deadlockWarning()) continue;
                this._communicator.getLogger().warning("Deadlock in Freeze.ObjectStore.dhHasObject while reading Db \"" + this._evictor.filename() + "/" + this._dbName + "\"");
                if (tx == null) continue;
                DeadlockException ex = new DeadlockException(this._evictor.errorPrefix() + "Db.get: " + dx.getMessage(), transaction);
                ex.initCause(dx);
                throw ex;
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                DatabaseException ex = new DatabaseException(this._evictor.errorPrefix() + "Db.get: " + dx.getMessage());
                ex.initCause(dx);
                throw ex;
            }
            break;
        }
    }

    void save(byte[] key, byte[] value, byte status, com.sleepycat.db.Transaction tx) throws com.sleepycat.db.DatabaseException {
        assert (tx != null);
        switch (status) {
            case 1: 
            case 2: {
                DatabaseEntry dbKey = new DatabaseEntry(key);
                DatabaseEntry dbValue = new DatabaseEntry(value);
                OperationStatus err = status == 1 ? this._db.putNoOverwrite(tx, dbKey, dbValue) : this._db.put(tx, dbKey, dbValue);
                if (err == OperationStatus.SUCCESS) break;
                throw new DatabaseException();
            }
            case 3: {
                DatabaseEntry dbKey = new DatabaseEntry(key);
                OperationStatus err = this._db.delete(tx, dbKey);
                if (err == OperationStatus.SUCCESS) break;
                throw new DatabaseException();
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    static byte[] marshalKey(Identity v, Communicator communicator) {
        BasicStream os = new BasicStream(Ice.Util.getInstance(communicator));
        v.__write(os);
        Buffer buf = os.prepareWrite();
        byte[] r = new byte[buf.size()];
        buf.b.get(r);
        return r;
    }

    static Identity unmarshalKey(byte[] b, Communicator communicator) {
        BasicStream is = new BasicStream(Ice.Util.getInstance(communicator));
        is.resize(b.length, true);
        Buffer buf = is.getBuffer();
        buf.b.position(0);
        buf.b.put(b);
        buf.b.position(0);
        Identity key = new Identity();
        key.__read(is);
        return key;
    }

    static byte[] marshalValue(ObjectRecord v, Communicator communicator) {
        BasicStream os = new BasicStream(Ice.Util.getInstance(communicator));
        os.startWriteEncaps();
        v.__write(os);
        os.writePendingObjects();
        os.endWriteEncaps();
        Buffer buf = os.prepareWrite();
        byte[] r = new byte[buf.size()];
        buf.b.get(r);
        return r;
    }

    static ObjectRecord unmarshalValue(byte[] b, Communicator communicator) {
        BasicStream is = new BasicStream(Ice.Util.getInstance(communicator));
        is.sliceObjects(false);
        is.resize(b.length, true);
        Buffer buf = is.getBuffer();
        buf.b.position(0);
        buf.b.put(b);
        buf.b.position(0);
        ObjectRecord rec = new ObjectRecord();
        is.startReadEncaps();
        rec.__read(is);
        is.readPendingObjects();
        is.endReadEncaps();
        return rec;
    }

    final Cache cache() {
        return this._cache;
    }

    final Database db() {
        return this._db;
    }

    final Communicator communicator() {
        return this._communicator;
    }

    final EvictorI evictor() {
        return this._evictor;
    }

    final String facet() {
        return this._facet;
    }

    final String dbName() {
        return this._dbName;
    }

    final Ice.Object sampleServant() {
        return this._sampleServant;
    }

    public Object load(Object identObj) {
        Identity ident = (Identity)identObj;
        byte[] key = ObjectStore.marshalKey(ident, this._communicator);
        DatabaseEntry dbKey = new DatabaseEntry(key);
        DatabaseEntry dbValue = new DatabaseEntry();
        while (true) {
            try {
                OperationStatus rs = this._db.get(null, dbKey, dbValue, null);
                if (rs == OperationStatus.NOTFOUND) {
                    return null;
                }
                if (rs != OperationStatus.SUCCESS) {
                    assert (false);
                    throw new DatabaseException();
                }
            }
            catch (com.sleepycat.db.DeadlockException dx) {
                if (!this._evictor.deadlockWarning()) continue;
                this._communicator.getLogger().warning("Deadlock in Freeze.ObjectStore.load while reading Db \"" + this._evictor.filename() + "/" + this._dbName + "\"; retrying...");
                continue;
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = this._evictor.errorPrefix() + "Db.get: " + dx.getMessage();
                throw ex;
            }
            break;
        }
        ObjectRecord rec = ObjectStore.unmarshalValue(dbValue.getData(), this._communicator);
        this._evictor.initialize(ident, this._facet, rec.servant);
        Object result = this._evictor.createEvictorElement(ident, rec, this);
        return result;
    }

    ObjectRecord load(Identity ident, TransactionI transaction) {
        if (transaction == null) {
            throw new DatabaseException(this._evictor.errorPrefix() + "no active transaction");
        }
        com.sleepycat.db.Transaction tx = transaction.dbTxn();
        if (tx == null) {
            throw new DatabaseException(this._evictor.errorPrefix() + "inactive transaction");
        }
        byte[] key = ObjectStore.marshalKey(ident, this._communicator);
        DatabaseEntry dbKey = new DatabaseEntry(key);
        DatabaseEntry dbValue = new DatabaseEntry();
        try {
            OperationStatus rs = this._db.get(tx, dbKey, dbValue, null);
            if (rs == OperationStatus.NOTFOUND) {
                return null;
            }
            if (rs != OperationStatus.SUCCESS) {
                assert (false);
                throw new DatabaseException();
            }
        }
        catch (com.sleepycat.db.DeadlockException dx) {
            if (this._evictor.deadlockWarning()) {
                this._communicator.getLogger().warning("Deadlock in Freeze.ObjectStore.load while reading Db \"" + this._evictor.filename() + "/" + this._dbName + "\"");
            }
            DeadlockException ex = new DeadlockException(this._evictor.errorPrefix() + "Db.get: " + dx.getMessage(), transaction);
            ex.initCause(dx);
            throw ex;
        }
        catch (com.sleepycat.db.DatabaseException dx) {
            DatabaseException ex = new DatabaseException();
            ex.initCause(dx);
            ex.message = this._evictor.errorPrefix() + "Db.get: " + dx.getMessage();
            throw ex;
        }
        ObjectRecord rec = ObjectStore.unmarshalValue(dbValue.getData(), this._communicator);
        this._evictor.initialize(ident, this._facet, rec.servant);
        return rec;
    }

    void update(Identity ident, ObjectRecord objectRecord, TransactionI transaction) {
        if (transaction == null) {
            throw new DatabaseException(this._evictor.errorPrefix() + "no active transaction");
        }
        com.sleepycat.db.Transaction tx = transaction.dbTxn();
        if (tx == null) {
            throw new DatabaseException(this._evictor.errorPrefix() + "inactive transaction");
        }
        if (this._sampleServant != null && !objectRecord.servant.ice_id().equals(this._sampleServant.ice_id())) {
            String msg = this._evictor.errorPrefix() + "Attempting to save a '" + objectRecord.servant.ice_id() + "' servant in a database of '" + this._sampleServant.ice_id() + "' servants";
            throw new DatabaseException(msg);
        }
        DatabaseEntry dbKey = new DatabaseEntry(ObjectStore.marshalKey(ident, this._communicator));
        DatabaseEntry dbValue = new DatabaseEntry(ObjectStore.marshalValue(objectRecord, this._communicator));
        try {
            OperationStatus err = this._db.put(tx, dbKey, dbValue);
            if (err != OperationStatus.SUCCESS) {
                throw new DatabaseException();
            }
        }
        catch (com.sleepycat.db.DeadlockException dx) {
            if (this._evictor.deadlockWarning()) {
                this._communicator.getLogger().warning("Deadlock in Freeze.ObjectStore.update while updating Db \"" + this._evictor.filename() + "/" + this._dbName + "\"");
            }
            DeadlockException ex = new DeadlockException(this._evictor.errorPrefix() + "Db.put: " + dx.getMessage(), transaction);
            ex.initCause(dx);
            throw ex;
        }
        catch (com.sleepycat.db.DatabaseException dx) {
            DatabaseException ex = new DatabaseException();
            ex.initCause(dx);
            ex.message = this._evictor.errorPrefix() + "Db.put: " + dx.getMessage();
            throw ex;
        }
    }

    boolean insert(Identity ident, ObjectRecord objectRecord, TransactionI transaction) {
        com.sleepycat.db.Transaction tx = null;
        if (transaction != null && (tx = transaction.dbTxn()) == null) {
            throw new DatabaseException(this._evictor.errorPrefix() + "invalid transaction");
        }
        DatabaseEntry dbKey = new DatabaseEntry(ObjectStore.marshalKey(ident, this._communicator));
        DatabaseEntry dbValue = new DatabaseEntry(ObjectStore.marshalValue(objectRecord, this._communicator));
        if (this._sampleServant != null && !objectRecord.servant.ice_id().equals(this._sampleServant.ice_id())) {
            String msg = this._evictor.errorPrefix() + "Attempting to save a '" + objectRecord.servant.ice_id() + "' servant in a database of '" + this._sampleServant.ice_id() + "' servants";
            throw new DatabaseException(msg);
        }
        while (true) {
            try {
                return this._db.putNoOverwrite(tx, dbKey, dbValue) == OperationStatus.SUCCESS;
            }
            catch (com.sleepycat.db.DeadlockException dx) {
                if (!this._evictor.deadlockWarning()) continue;
                this._communicator.getLogger().warning("Deadlock in Freeze.ObjectStore.update while updating Db \"" + this._evictor.filename() + "/" + this._dbName + "\"");
                if (tx == null) continue;
                DeadlockException ex = new DeadlockException(this._evictor.errorPrefix() + "Db.putNoOverwrite: " + dx.getMessage(), transaction);
                ex.initCause(dx);
                throw ex;
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = this._evictor.errorPrefix() + "Db.putNoOverwrite: " + dx.getMessage();
                throw ex;
            }
            break;
        }
    }

    boolean remove(Identity ident, TransactionI transaction) {
        com.sleepycat.db.Transaction tx = null;
        if (transaction != null && (tx = transaction.dbTxn()) == null) {
            throw new DatabaseException(this._evictor.errorPrefix() + "invalid transaction");
        }
        DatabaseEntry dbKey = new DatabaseEntry(ObjectStore.marshalKey(ident, this._communicator));
        while (true) {
            try {
                return this._db.delete(tx, dbKey) == OperationStatus.SUCCESS;
            }
            catch (com.sleepycat.db.DeadlockException dx) {
                if (!this._evictor.deadlockWarning()) continue;
                this._communicator.getLogger().warning("Deadlock in Freeze.ObjectStore.remove while updating Db \"" + this._evictor.filename() + "/" + this._dbName + "\"");
                if (tx == null) continue;
                DeadlockException ex = new DeadlockException(this._evictor.errorPrefix() + "Db.delete: " + dx.getMessage(), transaction);
                ex.initCause(dx);
                throw ex;
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = this._evictor.errorPrefix() + "Db.delete: " + dx.getMessage();
                throw ex;
            }
            break;
        }
    }
}

