/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.DatabaseException;
import Freeze.DeadlockException;
import Freeze.EvictorI;
import Freeze.ObjectRecord;
import Freeze.ObjectStore;
import Freeze.TransactionI;
import Ice.Communicator;
import Ice.Identity;
import Ice.Properties;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SecondaryCursor;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.SecondaryKeyCreator;
import com.sleepycat.db.Transaction;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public abstract class Index
implements SecondaryKeyCreator {
    private final String _name;
    private final String _facet;
    private String _dbName;
    private SecondaryDatabase _db = null;
    private ObjectStore _store = null;

    public boolean createSecondaryKey(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry value, DatabaseEntry result) throws com.sleepycat.db.DatabaseException {
        Communicator communicator = this._store.communicator();
        ObjectRecord rec = ObjectStore.unmarshalValue(value.getData(), communicator);
        byte[] secondaryKey = this.marshalKey(rec.servant);
        if (secondaryKey != null) {
            result.setData(secondaryKey);
            result.setSize(secondaryKey.length);
            return true;
        }
        return false;
    }

    public String name() {
        return this._name;
    }

    public String facet() {
        return this._facet;
    }

    protected Index(String name, String facet) {
        this._name = name;
        this._facet = facet;
    }

    protected abstract byte[] marshalKey(Ice.Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Identity[] untypedFindFirst(byte[] k, int firstN) {
        EvictorI.DeactivateController deactivateController = this._store.evictor().deactivateController();
        deactivateController.lock();
        try {
            ArrayList<Identity> identities;
            DatabaseEntry key = new DatabaseEntry(k);
            key.setPartial(true);
            DatabaseEntry pkey = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            value.setPartial(true);
            Communicator communicator = this._store.communicator();
            TransactionI transaction = this._store.evictor().beforeQuery();
            Transaction tx = transaction == null ? null : transaction.dbTxn();
            while (true) {
                SecondaryCursor dbc = null;
                identities = new ArrayList<Identity>();
                try {
                    boolean found;
                    dbc = this._db.openSecondaryCursor(tx, null);
                    boolean first = true;
                    do {
                        OperationStatus status = first ? dbc.getSearchKey(key, pkey, value, null) : dbc.getNextDup(key, pkey, value, null);
                        boolean bl = found = status == OperationStatus.SUCCESS;
                        if (!found) continue;
                        Identity ident = ObjectStore.unmarshalKey(pkey.getData(), communicator);
                        identities.add(ident);
                        first = false;
                    } while ((firstN <= 0 || identities.size() < firstN) && found);
                }
                catch (com.sleepycat.db.DeadlockException dx) {
                    if (this._store.evictor().deadlockWarning()) {
                        communicator.getLogger().warning("Deadlock in Freeze.Index.untypedFindFirst while iterating over Db \"" + this._store.evictor().filename() + "/" + this._dbName + "\"");
                    }
                    if (tx == null) continue;
                    DeadlockException ex = new DeadlockException(this._store.evictor().errorPrefix() + "Db.cursor: " + dx.getMessage(), transaction);
                    ex.initCause(dx);
                    throw ex;
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = this._store.evictor().errorPrefix() + "Db.cursor: " + dx.getMessage();
                    throw ex;
                }
                finally {
                    if (dbc == null) continue;
                    try {
                        dbc.close();
                    }
                    catch (com.sleepycat.db.DeadlockException dx) {
                        if (tx == null) continue;
                        DeadlockException ex = new DeadlockException(this._store.evictor().errorPrefix() + "Db.cursor: " + dx.getMessage(), transaction);
                        ex.initCause(dx);
                        throw ex;
                    }
                    catch (com.sleepycat.db.DatabaseException dx) {}
                    continue;
                }
                break;
            }
            if (identities.size() != 0) {
                Identity[] result = new Identity[identities.size()];
                Identity[] identityArray = identities.toArray(result);
                return identityArray;
            }
            Identity[] identityArray = new Identity[]{};
            return identityArray;
        }
        finally {
            deactivateController.unlock();
        }
    }

    protected Identity[] untypedFind(byte[] key) {
        return this.untypedFindFirst(key, 0);
    }

    /*
     * Loose catch block
     */
    protected int untypedCount(byte[] k) {
        EvictorI.DeactivateController deactivateController = this._store.evictor().deactivateController();
        deactivateController.lock();
        try {
            DatabaseEntry key = new DatabaseEntry(k);
            key.setPartial(true);
            DatabaseEntry value = new DatabaseEntry();
            value.setPartial(true);
            TransactionI transaction = this._store.evictor().beforeQuery();
            Transaction tx = transaction == null ? null : transaction.dbTxn();
            while (true) {
                Cursor dbc = null;
                try {
                    dbc = this._db.openCursor(tx, null);
                    if (dbc.getSearchKey(key, value, null) == OperationStatus.SUCCESS) {
                        int n = dbc.count();
                        return n;
                    }
                    int n = 0;
                    return n;
                }
                catch (com.sleepycat.db.DeadlockException dx) {
                    if (this._store.evictor().deadlockWarning()) {
                        this._store.communicator().getLogger().warning("Deadlock in Freeze.Index.untypedCount while iterating over Db \"" + this._store.evictor().filename() + "/" + this._dbName + "\"");
                    }
                    if (tx == null) continue;
                    DeadlockException ex = new DeadlockException(this._store.evictor().errorPrefix() + "Db.cursor: " + dx.getMessage(), transaction);
                    ex.initCause(dx);
                    throw ex;
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = this._store.evictor().errorPrefix() + "Db.cursor: " + dx.getMessage();
                    throw ex;
                }
                finally {
                    if (dbc == null) continue;
                    try {
                        dbc.close();
                    }
                    catch (com.sleepycat.db.DeadlockException dx) {
                        if (tx == null) continue;
                        DeadlockException ex = new DeadlockException(this._store.evictor().errorPrefix() + "Db.cursor: " + dx.getMessage(), transaction);
                        ex.initCause(dx);
                        throw ex;
                    }
                    catch (com.sleepycat.db.DatabaseException dx) {}
                    continue;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                break;
            }
        }
        finally {
            deactivateController.unlock();
        }
    }

    protected final Communicator communicator() {
        return this._store.communicator();
    }

    void associate(ObjectStore store, Transaction txn, boolean createDb, boolean populateIndex) throws com.sleepycat.db.DatabaseException, FileNotFoundException {
        boolean checksum;
        assert (txn != null);
        this._store = store;
        this._dbName = "$index:" + store.dbName() + "." + this._name;
        SecondaryConfig config = new SecondaryConfig();
        config.setAllowCreate(createDb);
        config.setAllowPopulate(populateIndex);
        config.setSortedDuplicates(true);
        config.setType(DatabaseType.BTREE);
        config.setKeyCreator((SecondaryKeyCreator)this);
        Properties properties = store.evictor().communicator().getProperties();
        String propPrefix = "Freeze.Evictor." + store.evictor().filename() + ".";
        int btreeMinKey = properties.getPropertyAsInt(propPrefix + this._dbName + ".BtreeMinKey");
        if (btreeMinKey > 2) {
            if (store.evictor().trace() >= 1) {
                store.evictor().communicator().getLogger().trace("Freeze.Evictor", "Setting \"" + store.evictor().filename() + "." + this._dbName + "\"'s btree minkey to " + btreeMinKey);
            }
            config.setBtreeMinKey(btreeMinKey);
        }
        boolean bl = checksum = properties.getPropertyAsInt(propPrefix + "Checksum") > 0;
        if (checksum) {
            config.setChecksum(true);
        }
        this._db = this._store.evictor().dbEnv().getEnv().openSecondaryDatabase(txn, this._store.evictor().filename(), this._dbName, this._store.db(), config);
    }

    void close() {
        if (this._db != null) {
            try {
                this._db.close();
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = this._store.evictor().errorPrefix() + "Db.close: " + dx.getMessage();
                throw ex;
            }
            this._db = null;
        }
    }
}

