/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.Connection;
import Freeze.DatabaseException;
import Freeze.DeadlockException;
import Freeze.IndexNotFoundException;
import Freeze.LinkedList;
import Freeze.Map;
import Freeze.SharedDbEnv;
import Freeze.Transaction;
import Freeze.TransactionAlreadyInProgressException;
import Freeze.TransactionI;
import Ice.Communicator;
import Ice.Properties;
import com.sleepycat.db.Environment;
import java.io.FileNotFoundException;
import java.util.Iterator;

class ConnectionI
implements Connection {
    private Communicator _communicator;
    private SharedDbEnv _dbEnv;
    private String _envName;
    private TransactionI _transaction;
    private LinkedList _mapList = new LinkedList();
    private int _trace;
    private int _txTrace;
    private boolean _deadlockWarning;
    private boolean _closeInFinalizeWarning;

    public Transaction beginTransaction() {
        if (this._transaction != null) {
            throw new TransactionAlreadyInProgressException();
        }
        this.closeAllIterators();
        this._transaction = new TransactionI(this);
        return this._transaction;
    }

    public Transaction currentTransaction() {
        return this._transaction;
    }

    public void removeMapIndex(String mapName, String indexName) {
        if (this._dbEnv == null) {
            throw new DatabaseException("Closed connection");
        }
        try {
            this._dbEnv.getEnv().removeDatabase(this.dbTxn(), mapName + "." + indexName, null);
        }
        catch (com.sleepycat.db.DeadlockException dx) {
            DeadlockException ex = new DeadlockException(this.errorPrefix() + dx.getMessage(), this._transaction);
            ex.initCause(dx);
            throw ex;
        }
        catch (com.sleepycat.db.DatabaseException dx) {
            DatabaseException ex = new DatabaseException(this.errorPrefix() + dx.getMessage());
            ex.initCause(dx);
            throw ex;
        }
        catch (FileNotFoundException fne) {
            throw new IndexNotFoundException(mapName, indexName);
        }
    }

    public void close() {
        this.close(false);
    }

    public Communicator getCommunicator() {
        return this._communicator;
    }

    public String getName() {
        return this._envName;
    }

    protected void finalize() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean finalizing) {
        if (this._transaction != null) {
            if (finalizing) {
                this._communicator.getLogger().warning("Finalizing Connection on DbEnv \"" + this._envName + "\" with active transaction");
            }
            try {
                this._transaction.rollback();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            Iterator p = this._mapList.iterator();
            while (p.hasNext()) {
                ((Map)p.next()).close(finalizing);
            }
        }
        if (this._dbEnv != null) {
            try {
                this._dbEnv.close();
            }
            finally {
                this._dbEnv = null;
            }
        }
    }

    ConnectionI(SharedDbEnv dbEnv) {
        this._dbEnv = dbEnv;
        this._communicator = dbEnv.getCommunicator();
        this._envName = dbEnv.getEnvName();
        this._trace = this._communicator.getProperties().getPropertyAsInt("Freeze.Trace.Map");
        this._txTrace = this._communicator.getProperties().getPropertyAsInt("Freeze.Trace.Transaction");
        Properties properties = this._communicator.getProperties();
        this._deadlockWarning = properties.getPropertyAsInt("Freeze.Warn.Deadlocks") > 0;
        this._closeInFinalizeWarning = properties.getPropertyAsIntWithDefault("Freeze.Warn.CloseInFinalize", 1) > 0;
    }

    ConnectionI(Communicator communicator, String envName, Environment dbEnv) {
        this(SharedDbEnv.get(communicator, envName, dbEnv));
    }

    synchronized void closeAllIterators() {
        Iterator p = this._mapList.iterator();
        while (p.hasNext()) {
            ((Map)p.next()).closeAllIterators();
        }
    }

    synchronized Iterator registerMap(Map map) {
        this._mapList.addFirst(map);
        Iterator p = this._mapList.iterator();
        p.next();
        return p;
    }

    synchronized void unregisterMap(Iterator p) {
        p.remove();
    }

    void clearTransaction() {
        this._transaction = null;
    }

    com.sleepycat.db.Transaction dbTxn() {
        if (this._transaction == null) {
            return null;
        }
        return this._transaction.dbTxn();
    }

    SharedDbEnv dbEnv() {
        return this._dbEnv;
    }

    String envName() {
        return this._envName;
    }

    Communicator communicator() {
        return this._communicator;
    }

    final int trace() {
        return this._trace;
    }

    final int txTrace() {
        return this._txTrace;
    }

    final boolean deadlockWarning() {
        return this._deadlockWarning;
    }

    final boolean closeInFinalizeWarning() {
        return this._closeInFinalizeWarning;
    }

    private String errorPrefix() {
        return "DbEnv(\"" + this._envName + "\"): ";
    }
}

