/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.List;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RBool;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.FilterSet;
import omero.model.IObject;
import omero.model.Instrument;
import omero.model.OTF;
import omero.model.Objective;
import omero.model.PixelsType;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTFI
extends OTF
implements ModelBased {
    public static final String SIZEX = "ome.model.acquisition.OTF_sizeX";
    public static final String SIZEY = "ome.model.acquisition.OTF_sizeY";
    public static final String OPTICALAXISAVERAGED = "ome.model.acquisition.OTF_opticalAxisAveraged";
    public static final String PIXELSTYPE = "ome.model.acquisition.OTF_pixelsType";
    public static final String PATH = "ome.model.acquisition.OTF_path";
    public static final String FILTERSET = "ome.model.acquisition.OTF_filterSet";
    public static final String OBJECTIVE = "ome.model.acquisition.OTF_objective";
    public static final String INSTRUMENT = "ome.model.acquisition.OTF_instrument";
    public static final String DETAILS = "ome.model.acquisition.OTF_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
    }

    public OTFI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public OTFI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public OTFI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadSizeX();
        this.unloadSizeY();
        this.unloadOpticalAxisAveraged();
        this.unloadPixelsType();
        this.unloadPath();
        this.unloadFilterSet();
        this.unloadObjective();
        this.unloadInstrument();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        OTFI copy = new OTFI();
        copy.id = this.id;
        copy.version = this.version;
        copy.sizeX = this.sizeX;
        copy.sizeY = this.sizeY;
        copy.opticalAxisAveraged = this.opticalAxisAveraged;
        copy.pixelsType = this.pixelsType == null ? null : (PixelsType)this.pixelsType.proxy();
        copy.path = this.path;
        copy.filterSet = this.filterSet == null ? null : (FilterSet)this.filterSet.proxy();
        copy.objective = this.objective == null ? null : (Objective)this.objective.proxy();
        copy.instrument = this.instrument == null ? null : (Instrument)this.instrument.proxy();
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new OTFI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadSizeX() {
        this.sizeX = null;
    }

    @Override
    public RInt getSizeX(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.sizeX;
    }

    @Override
    public void setSizeX(RInt sizeX, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.sizeX = sizeX;
    }

    private void copySizeX(ome.model.acquisition.OTF source, IceMapper mapper) {
        this.sizeX = source.getSizeX() == null ? null : rtypes.rint(source.getSizeX());
    }

    private void fillSizeX(ome.model.acquisition.OTF target, IceMapper mapper) {
        try {
            target.setSizeX((Integer)mapper.fromRType(this.getSizeX()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadSizeY() {
        this.sizeY = null;
    }

    @Override
    public RInt getSizeY(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.sizeY;
    }

    @Override
    public void setSizeY(RInt sizeY, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.sizeY = sizeY;
    }

    private void copySizeY(ome.model.acquisition.OTF source, IceMapper mapper) {
        this.sizeY = source.getSizeY() == null ? null : rtypes.rint(source.getSizeY());
    }

    private void fillSizeY(ome.model.acquisition.OTF target, IceMapper mapper) {
        try {
            target.setSizeY((Integer)mapper.fromRType(this.getSizeY()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadOpticalAxisAveraged() {
        this.opticalAxisAveraged = null;
    }

    @Override
    public RBool getOpticalAxisAveraged(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.opticalAxisAveraged;
    }

    @Override
    public void setOpticalAxisAveraged(RBool opticalAxisAveraged, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.opticalAxisAveraged = opticalAxisAveraged;
    }

    private void copyOpticalAxisAveraged(ome.model.acquisition.OTF source, IceMapper mapper) {
        this.opticalAxisAveraged = source.getOpticalAxisAveraged() == null ? null : rtypes.rbool(source.getOpticalAxisAveraged());
    }

    private void fillOpticalAxisAveraged(ome.model.acquisition.OTF target, IceMapper mapper) {
        try {
            target.setOpticalAxisAveraged((Boolean)mapper.fromRType(this.getOpticalAxisAveraged()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadPixelsType() {
        this.pixelsType = null;
    }

    @Override
    public PixelsType getPixelsType(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.pixelsType;
    }

    @Override
    public void setPixelsType(PixelsType pixelsType, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.pixelsType = pixelsType;
    }

    private void copyPixelsType(ome.model.acquisition.OTF source, IceMapper mapper) {
        this.pixelsType = (PixelsType)mapper.findTarget(source.getPixelsType());
    }

    private void fillPixelsType(ome.model.acquisition.OTF target, IceMapper mapper) {
        target.putAt(PIXELSTYPE, (Object)mapper.reverse((ModelBased)this.getPixelsType()));
    }

    public void unloadPath() {
        this.path = null;
    }

    @Override
    public RString getPath(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.path;
    }

    @Override
    public void setPath(RString path, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.path = path;
    }

    private void copyPath(ome.model.acquisition.OTF source, IceMapper mapper) {
        this.path = source.getPath() == null ? null : rtypes.rstring(source.getPath());
    }

    private void fillPath(ome.model.acquisition.OTF target, IceMapper mapper) {
        try {
            target.setPath((String)mapper.fromRType(this.getPath()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadFilterSet() {
        this.filterSet = null;
    }

    @Override
    public FilterSet getFilterSet(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.filterSet;
    }

    @Override
    public void setFilterSet(FilterSet filterSet, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.filterSet = filterSet;
    }

    private void copyFilterSet(ome.model.acquisition.OTF source, IceMapper mapper) {
        this.filterSet = (FilterSet)mapper.findTarget(source.getFilterSet());
    }

    private void fillFilterSet(ome.model.acquisition.OTF target, IceMapper mapper) {
        target.putAt(FILTERSET, (Object)mapper.reverse((ModelBased)this.getFilterSet()));
    }

    public void unloadObjective() {
        this.objective = null;
    }

    @Override
    public Objective getObjective(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.objective;
    }

    @Override
    public void setObjective(Objective objective, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.objective = objective;
    }

    private void copyObjective(ome.model.acquisition.OTF source, IceMapper mapper) {
        this.objective = (Objective)mapper.findTarget(source.getObjective());
    }

    private void fillObjective(ome.model.acquisition.OTF target, IceMapper mapper) {
        target.putAt(OBJECTIVE, (Object)mapper.reverse((ModelBased)this.getObjective()));
    }

    public void unloadInstrument() {
        this.instrument = null;
    }

    @Override
    public Instrument getInstrument(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.instrument;
    }

    @Override
    public void setInstrument(Instrument instrument, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.instrument = instrument;
    }

    private void copyInstrument(ome.model.acquisition.OTF source, IceMapper mapper) {
        this.instrument = (Instrument)mapper.findTarget(source.getInstrument());
    }

    private void fillInstrument(ome.model.acquisition.OTF target, IceMapper mapper) {
        target.putAt(INSTRUMENT, (Object)mapper.reverse((ModelBased)this.getInstrument()));
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.acquisition.OTF) {
            ome.model.acquisition.OTF source = (ome.model.acquisition.OTF)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copySizeX(source, mapper);
                this.copySizeY(source, mapper);
                this.copyOpticalAxisAveraged(source, mapper);
                this.copyPixelsType(source, mapper);
                this.copyPath(source, mapper);
                this.copyFilterSet(source, mapper);
                this.copyObjective(source, mapper);
                this.copyInstrument(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("OTF cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.acquisition.OTF target = new ome.model.acquisition.OTF();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillSizeX(target, mapper);
            this.fillSizeY(target, mapper);
            this.fillOpticalAxisAveraged(target, mapper);
            this.fillPixelsType(target, mapper);
            this.fillPath(target, mapper);
            this.fillFilterSet(target, mapper);
            this.fillObjective(target, mapper);
            this.fillInstrument(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<OTFI> cast(List list) {
        return list;
    }
}

